/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.exception.response;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.exception.command.ExceptionTraceConfiguration;
import com.sap.jvm.profiling.exception.event.ExceptionEventHandler;
import com.sap.jvm.profiling.exception.response.EnableExceptionTraceResponse;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class EnableExceptionTraceResponseImpl
extends ResponseImpl
implements EnableExceptionTraceResponse {
    private final ExceptionTraceConfiguration config = new ExceptionTraceConfiguration();

    public static EnableExceptionTraceResponseImpl read(ResourceReader reader, ExceptionEventHandler[] handlers) throws IOException {
        EnableExceptionTraceResponseImpl retValue = new EnableExceptionTraceResponseImpl(reader);
        for (ExceptionEventHandler handler : handlers) {
            handler.handle(retValue);
        }
        return retValue;
    }

    private EnableExceptionTraceResponseImpl(ResourceReader reader) throws IOException {
        super("enable exception trace response", reader);
        this.config.setIncludeLineNrs(reader.readBoolean());
        this.config.setIncludeCauses(reader.readBoolean());
        this.config.setIncludeThrowStackTrace(reader.readBoolean());
        this.config.setExceptionClassFilter(reader.readString());
        this.config.setExceptionStackTraceClassFilter(reader.readString());
        this.config.setExceptionStackTraceMethodFilter(reader.readString());
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1051);
        this.writeInternal(writer);
        writer.writeBoolean(this.config.getIncludeLineNrs());
        writer.writeBoolean(this.config.getIncludeCauses());
        writer.writeBoolean(this.config.getIncludeThrowStackTrace());
        writer.writeStringSafe(this.config.getExceptionClassFilter());
        writer.writeStringSafe(this.config.getExceptionStackTraceClassFilter());
        writer.writeStringSafe(this.config.getExceptionStackTraceMethodFilter());
        writer.finalizePacket();
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ENABLE_EXCEPTION_TRACE_RESPONSE;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnResponseHeader(this);
        stream.println("includeLineNrs: " + this.config.getIncludeLineNrs());
        stream.println("includeCauses: " + this.config.getIncludeCauses());
        stream.println("includeExceptionStackTraces: " + this.config.getIncludeThrowStackTrace());
        stream.println("exceptionClassFilter: " + this.config.getExceptionClassFilter());
        stream.println("exceptionStackTraceClassFilter: " + this.config.getExceptionStackTraceClassFilter());
        stream.println("exceptionStackTraceMethodFilter: " + this.config.getExceptionStackTraceMethodFilter());
    }

    @Override
    public ExceptionTraceConfiguration getConfig() {
        return this.config.copy();
    }
}

