/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.io.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.event.SystemInfo;
import com.sap.jvm.profiling.core.type.UTF8Creator;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.io.event.FileNotFoundEvent;
import com.sap.jvm.profiling.io.event.IOEventHandler;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.util.io.FileUtils;
import com.sap.jvm.util.misc.UTF8Util;
import java.io.IOException;

public final class FileNotFoundEventImpl
extends ProfilingPacketImpl
implements FileNotFoundEvent {
    private final UTF8String filename;
    private final UTF8String reason;
    private final int stackTraceIndex;
    private final char threadIndex;
    private final long timestamp;

    public static FileNotFoundEventImpl read(ResourceReader reader, IOEventHandler[] handlers, SystemInfo systemInfo) throws IOException {
        FileNotFoundEventImpl result = new FileNotFoundEventImpl(reader, systemInfo);
        for (IOEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    private FileNotFoundEventImpl(ResourceReader reader, SystemInfo systemInfo) throws IOException {
        this.filename = FileNotFoundEventImpl.convertInAbsoluteFilename(systemInfo.getWorkingDirectory(), reader.readUTF(), systemInfo.getProperties().get("file.separator").charAt(0));
        this.threadIndex = reader.readUint16();
        this.stackTraceIndex = reader.readStackTraceIndex();
        this.timestamp = reader.readInt64();
        this.reason = reader.readUTF();
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.FILE_NOT_FOUND_EVENT;
    }

    @Override
    public UTF8String getFilename() {
        return this.filename;
    }

    @Override
    public UTF8String getReason() {
        return this.reason;
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public int getStackTraceIndex() {
        return this.stackTraceIndex;
    }

    @Override
    public long getTimeStamp() {
        return this.timestamp;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("File        : %s", this.filename);
        stream.formatln("Reason      : %s", this.reason);
        stream.formatln("Thread      : %*T", this.threadIndex);
        stream.formatln("Stack trace : %*S", this.getStackTraceIndex());
        stream.formatln("Timestamp   : %d", this.timestamp);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)612);
        writer.writeUTF(this.filename);
        writer.writeUint16(this.threadIndex);
        writer.writeInt32(this.stackTraceIndex);
        writer.writeInt64(this.timestamp);
        writer.writeUTF(this.reason);
        writer.finalizePacket();
    }

    private static UTF8String convertInAbsoluteFilename(String workingDir, UTF8String filename, char pathSeparator) {
        String filenameStr = UTF8Util.asString(filename.getBytes());
        String absoluteFilename = FileUtils.concat(workingDir, filenameStr, pathSeparator);
        String normalizedFilename = FileUtils.normalize(absoluteFilename, pathSeparator);
        return UTF8Creator.create(normalizedFilename);
    }

    @Override
    public String getPacketName() {
        return "file not found event";
    }
}

