/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.io.event;

import com.sap.jvm.profiling.core.type.UTF8Creator;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.io.event.FileOpenEvent;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.util.io.FileUtils;
import com.sap.jvm.util.misc.UTF8Util;
import java.io.IOException;

public abstract class FileOpenEventBase
extends ProfilingPacketImpl
implements FileOpenEvent {
    private final UTF8String filename;
    private final int stackTraceIndex;
    private final char threadIndex;
    private final long timestamp;
    private final long fd;
    private final long id;

    protected FileOpenEventBase(UTF8String filename, long timestamp, long fd, long id, char threadIndex, int stackTraceIndex) {
        this.filename = filename;
        this.threadIndex = threadIndex;
        this.stackTraceIndex = stackTraceIndex;
        this.timestamp = timestamp;
        this.fd = fd;
        this.id = id;
    }

    @Override
    public UTF8String getFilename() {
        return this.filename;
    }

    @Override
    public long getFd() {
        return this.fd;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public int getStackTraceIndex() {
        return this.stackTraceIndex;
    }

    @Override
    public long getTimeStamp() {
        return this.timestamp;
    }

    protected static long readUniqueFileId(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        long tmpId = reader.readUniqueFileId();
        return tmpId == -1L ? mapInfo.createUniqueFileId() : tmpId;
    }

    protected static UTF8String convertInAbsoluteFilename(String workingDir, UTF8String filename, char pathSeparator) {
        String filenameStr = UTF8Util.asString(filename.getBytes());
        if (filenameStr != null && filenameStr.length() > 0 && filenameStr.charAt(0) == '<' && filenameStr.charAt(filenameStr.length() - 1) == '>') {
            assert ("<stdin>".equals(filenameStr) || "<stdout>".equals(filenameStr) || "<stderr>".equals(filenameStr));
            return filename;
        }
        String absoluteFilename = FileUtils.concat(workingDir, filenameStr, pathSeparator);
        String normalizedFilename = FileUtils.normalize(absoluteFilename, pathSeparator);
        return UTF8Creator.create(normalizedFilename);
    }
}

