/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.io.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.event.SystemInfo;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.io.event.FileOpenEventBase;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.io.event.IOEventHandler;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class FileOpenEventImpl
extends FileOpenEventBase {
    public static FileOpenEventImpl read(ResourceReader reader, IOEventHandler[] handlers, SystemInfo systemInfo, MappingInformation mapInfo) throws IOException {
        FileOpenEventImpl result = new FileOpenEventImpl(reader, systemInfo, mapInfo);
        for (IOEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    private FileOpenEventImpl(ResourceReader reader, SystemInfo systemInfo, MappingInformation mapInfo) throws IOException {
        this(FileOpenEventImpl.convertInAbsoluteFilename(systemInfo.getWorkingDirectory(), reader.readUTF(), systemInfo.getProperties().get("file.separator").charAt(0)), reader.readUint16(), reader.readStackTraceIndex(), reader.readInt64(), reader.readInt64(), FileOpenEventImpl.readUniqueFileId(reader, mapInfo));
        mapInfo.addFileOpenEvent(this);
    }

    private FileOpenEventImpl(UTF8String filename, char threadIndex, int stackTraceIndex, long timestamp, long fd, long id) {
        super(filename, timestamp, fd, id, threadIndex, stackTraceIndex);
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.FILE_OPEN_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("File        : %s", this.getFilename());
        stream.formatln("Fd          : %d", this.getFd());
        stream.formatln("Id          : %d", this.getId());
        stream.formatln("Thread      : %*T", this.getThreadIndex());
        stream.formatln("Stack trace : %*S", this.getStackTraceIndex());
        stream.formatln("Timestamp   : %d", this.getTimeStamp());
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)607);
        writer.writeUTF(this.getFilename());
        writer.writeUint16(this.getThreadIndex());
        writer.writeInt32(this.getStackTraceIndex());
        writer.writeInt64(this.getTimeStamp());
        writer.writeInt64(this.getFd());
        writer.writeInt64(this.getId());
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "file open event";
    }
}

