/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.io.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.io.event.FileWriteEvent;
import com.sap.jvm.profiling.io.event.IOEventHandler;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class FileWriteEventImpl
extends ProfilingPacketImpl
implements FileWriteEvent {
    private final int stackTraceIndex;
    private final char threadIndex;
    private final long duration;
    private final int nrOfWrittenBytes;
    private final long fd;
    private final long id;

    public static FileWriteEventImpl read(ResourceReader reader, IOEventHandler[] handlers, MappingInformation mapInfo) throws IOException {
        FileWriteEventImpl result = new FileWriteEventImpl(reader, mapInfo);
        for (IOEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    private FileWriteEventImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        this.threadIndex = reader.readUint16();
        this.stackTraceIndex = reader.readStackTraceIndex();
        int tmpNrOfWrittenBytes = reader.readInt32();
        this.nrOfWrittenBytes = tmpNrOfWrittenBytes == -1 ? 0 : tmpNrOfWrittenBytes;
        this.duration = reader.readInt64();
        this.fd = reader.readInt64();
        long tmpId = reader.readUniqueFileId();
        this.id = tmpId == -1L ? mapInfo.getUniqueFileId(this.fd) : tmpId;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.FILE_WRITE_EVENT;
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public int getStackTraceIndex() {
        return this.stackTraceIndex;
    }

    @Override
    public int getNrOfWrittenBytes() {
        return this.nrOfWrittenBytes;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public long getFd() {
        return this.fd;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Thread        : %*T", this.threadIndex);
        stream.formatln("Fd            : %d", this.fd);
        stream.formatln("Id            : %d", this.id);
        stream.formatln("Stack trace   : %*S", this.getStackTraceIndex());
        stream.formatln("Written Bytes : %d", this.nrOfWrittenBytes);
        stream.formatln("Duration      : %d", this.duration);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)611);
        writer.writeUint16(this.threadIndex);
        writer.writeInt32(this.stackTraceIndex);
        writer.writeInt32(this.nrOfWrittenBytes);
        writer.writeInt64(this.duration);
        writer.writeInt64(this.fd);
        writer.writeInt64(this.id);
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "file write event";
    }
}

