/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.io.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.io.event.IOEventHandler;
import com.sap.jvm.profiling.io.event.ZipFileCloseEvent;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class ZipFileCloseEventImpl
extends ProfilingPacketImpl
implements ZipFileCloseEvent {
    private final int stackTraceIndex;
    private final char threadIndex;
    private final long timestamp;
    private final long fd;
    private final long id;
    private final int index;

    public static ZipFileCloseEventImpl read(ResourceReader reader, IOEventHandler[] handlers, MappingInformation mapInfo) throws IOException {
        ZipFileCloseEventImpl result = new ZipFileCloseEventImpl(reader, mapInfo);
        if (result.getFd() < 0L) {
            return null;
        }
        for (IOEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    private ZipFileCloseEventImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        this.threadIndex = reader.readUint16();
        this.stackTraceIndex = reader.readStackTraceIndex();
        this.timestamp = reader.readInt64();
        this.fd = reader.readInt64();
        this.index = reader.readInt32();
        long tmpId = reader.readUniqueFileId();
        this.id = tmpId == -1L ? mapInfo.getUniqueZipFileId(this.fd, this.index) : tmpId;
        mapInfo.removeZipFileOpenEvent(this.fd, this.index);
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ZIP_FILE_CLOSE_EVENT;
    }

    @Override
    public long getFd() {
        return this.fd;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public int getStackTraceIndex() {
        return this.stackTraceIndex;
    }

    @Override
    public long getTimeStamp() {
        return this.timestamp;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Fd          : %d", this.fd);
        stream.formatln("Index       : %d", this.index);
        stream.formatln("Id          : %d", this.id);
        stream.formatln("Thread      : %*T", this.threadIndex);
        stream.formatln("Stack trace : %*S", this.getStackTraceIndex());
        stream.formatln("Timestamp   : %d", this.timestamp);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)618);
        writer.writeUint16(this.threadIndex);
        writer.writeInt32(this.stackTraceIndex);
        writer.writeInt64(this.timestamp);
        writer.writeInt64(this.fd);
        writer.writeInt32(this.index);
        writer.writeInt64(this.id);
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "zip file close event";
    }
}

