/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.io.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.event.SystemInfo;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.io.event.FileOpenEventBase;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.io.event.IOEventHandler;
import com.sap.jvm.profiling.io.event.ZipFileOpenEvent;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class ZipFileOpenEventImpl
extends FileOpenEventBase
implements ZipFileOpenEvent {
    private final int index;

    public static ZipFileOpenEventImpl read(ResourceReader reader, IOEventHandler[] handlers, SystemInfo systemInfo, MappingInformation mapInfo) throws IOException {
        ZipFileOpenEventImpl result = new ZipFileOpenEventImpl(reader, systemInfo, mapInfo);
        for (IOEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    private ZipFileOpenEventImpl(ResourceReader reader, SystemInfo systemInfo, MappingInformation mapInfo) throws IOException {
        this(ZipFileOpenEventImpl.convertInAbsoluteFilename(systemInfo.getWorkingDirectory(), reader.readUTF(), systemInfo.getProperties().get("file.separator").charAt(0)), reader.readUint16(), reader.readStackTraceIndex(), reader.readInt64(), reader.readInt64(), reader.readInt32(), ZipFileOpenEventImpl.readUniqueFileId(reader, mapInfo));
        mapInfo.addZipFileOpenEvent(this);
    }

    private ZipFileOpenEventImpl(UTF8String filename, char threadIndex, int stackTraceIndex, long timestamp, long fd, int index, long id) {
        super(filename, timestamp, fd, id, threadIndex, stackTraceIndex);
        this.index = index;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ZIP_FILE_OPEN_EVENT;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("File        : %s", this.getFilename());
        stream.formatln("Fd          : %d", this.getFd());
        stream.formatln("Index       : %d", this.index);
        stream.formatln("Id          : %d", this.getId());
        stream.formatln("Thread      : %*T", this.getThreadIndex());
        stream.formatln("Stack trace : %*S", this.getStackTraceIndex());
        stream.formatln("Timestamp   : %d", this.getTimeStamp());
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)616);
        writer.writeUTF(this.getFilename());
        writer.writeUint16(this.getThreadIndex());
        writer.writeInt32(this.getStackTraceIndex());
        writer.writeInt64(this.getTimeStamp());
        writer.writeInt64(this.getFd());
        writer.writeInt32(this.index);
        writer.writeInt64(this.getId());
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "zip file open event";
    }
}

