/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.io.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.io.event.IOEventHandler;
import com.sap.jvm.profiling.io.event.ZipFileReadEvent;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class ZipFileReadEventImpl
extends ProfilingPacketImpl
implements ZipFileReadEvent {
    private final int stackTraceIndex;
    private final char threadIndex;
    private final long duration;
    private final int nrOfReadBytes;
    private final long fd;
    private final int index;
    private final long id;

    public static ZipFileReadEventImpl read(ResourceReader reader, IOEventHandler[] handlers, MappingInformation mapInfo) throws IOException {
        ZipFileReadEventImpl result = new ZipFileReadEventImpl(reader, mapInfo);
        for (IOEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    private ZipFileReadEventImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        this.threadIndex = reader.readUint16();
        this.stackTraceIndex = reader.readStackTraceIndex();
        int tmpNrOfReadBytes = reader.readInt32();
        this.nrOfReadBytes = tmpNrOfReadBytes == -1 ? 0 : tmpNrOfReadBytes;
        this.duration = reader.readInt64();
        this.fd = reader.readInt64();
        this.index = reader.readInt32();
        long tmpId = reader.readUniqueFileId();
        this.id = tmpId == -1L ? mapInfo.getUniqueZipFileId(this.fd, this.index) : tmpId;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ZIP_FILE_READ_EVENT;
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public int getStackTraceIndex() {
        return this.stackTraceIndex;
    }

    @Override
    public int getNrOfReadBytes() {
        return this.nrOfReadBytes;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public long getFd() {
        return this.fd;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Thread      : %*T", this.threadIndex);
        stream.formatln("Fd          : %d", this.fd);
        stream.formatln("Index       : %d", this.index);
        stream.formatln("Id          : %d", this.id);
        stream.formatln("Stack trace : %*S", this.getStackTraceIndex());
        stream.formatln("Read Bytes  : %d", this.nrOfReadBytes);
        stream.formatln("Duration    : %d", this.duration);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)617);
        writer.writeUint16(this.threadIndex);
        writer.writeInt32(this.stackTraceIndex);
        writer.writeInt32(this.nrOfReadBytes);
        writer.writeInt64(this.duration);
        writer.writeInt64(this.fd);
        writer.writeInt32(this.index);
        writer.writeInt64(this.id);
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "zip file read event";
    }
}

