/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.io.response;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.io.command.IOTraceConfiguration;
import com.sap.jvm.profiling.io.event.IOEventHandler;
import com.sap.jvm.profiling.io.response.EnableIOTraceResponse;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class EnableIOTraceResponseImpl
extends ResponseImpl
implements EnableIOTraceResponse {
    private final IOTraceConfiguration configuration = new IOTraceConfiguration();

    public static EnableIOTraceResponseImpl read(ResourceReader reader, IOEventHandler[] handlers) throws IOException {
        EnableIOTraceResponseImpl retValue = new EnableIOTraceResponseImpl(reader);
        for (IOEventHandler handler : handlers) {
            handler.handle(retValue);
        }
        return retValue;
    }

    private EnableIOTraceResponseImpl(ResourceReader reader) throws IOException {
        super("enable io trace response", reader);
        if (reader.hasNext()) {
            this.configuration.setThreadFilter(reader.readNewThreadFilter());
        }
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1045);
        this.writeInternal(writer);
        writer.writeNewThreadFilter(this.configuration.getThreadFilter());
        writer.finalizePacket();
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ENABLE_IO_TRACE_RESPONSE;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnResponseHeader(this);
        stream.formatln("Thread filter         : %s", this.configuration.getThreadFilter().asString());
    }

    @Override
    public IOTraceConfiguration getConfiguration() {
        return this.configuration;
    }
}

