/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.jit.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.jit.event.JitEventBaseImpl;
import com.sap.jvm.profiling.impl.jit.event.JitSubEventBaseImpl;
import com.sap.jvm.profiling.impl.jit.event.JitSubEventMethodInlinedImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.jit.event.JitEventMethodCompilation;
import com.sap.jvm.profiling.resource.PacketResourceReader;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import java.io.IOException;

public final class JitEventMethodCompilationImpl
extends JitEventBaseImpl
implements JitEventMethodCompilation {
    private final MethodObject compiledMethod;
    private final int entryBci;
    private final int compileId;
    private final byte bitfield;
    private final int[] nrOfSubEvents;
    private final JitSubEventBaseImpl[][] jitSubEvents;
    private final UTF8String failureMsg;
    private final UTF8String ciEnvfailureMsg;
    private static final int COMP_FAILED_BITS = 1;
    private static final int COMP_LEVEL_BITS = 3;
    private static final int IS_OSR_BITS = 1;
    private static final int COMP_FAILED_SHIFT = 0;
    private static final int COMP_LEVEL_SHIFT = 1;
    private static final int IS_OSR_SHIFT = 4;
    private static final int COMP_FAILED_MASK = JitEventMethodCompilationImpl.right_n_bits(1);
    private static final int COMP_LEVEL_MASK = JitEventMethodCompilationImpl.right_n_bits(3);
    private static final int IS_OSR_MASK = JitEventMethodCompilationImpl.right_n_bits(1);

    private JitEventMethodCompilationImpl(PacketResourceReader reader, MappingInformation mapInfo) throws IOException {
        super(reader);
        this.compileId = reader.readCompressedInt32();
        assert (this.compileId > 0 && this.compileId < 500000);
        this.compiledMethod = reader.readMethodObject();
        this.bitfield = reader.readInt8();
        int n = this.entryBci = this.isOSR() ? (int)reader.readUint16() : 65535;
        assert (!this.isOSR() || 0 <= this.entryBci && this.entryBci < 10000);
        this.failureMsg = this.compilationFailed() ? reader.readInternedUTF() : null;
        this.ciEnvfailureMsg = this.compilationFailed() ? reader.readInternedUTF() : null;
        this.nrOfSubEvents = new int[JitSubEventBaseImpl.JIT_SUBEVENT_COMP_LAST];
        this.jitSubEvents = new JitSubEventBaseImpl[JitSubEventBaseImpl.JIT_SUBEVENT_COMP_LAST][];
        int type = JitSubEventBaseImpl.JIT_SUBEVENT_COMP_METHOD_INLINED;
        this.nrOfSubEvents[type] = reader.readUint16();
        assert (0 <= this.nrOfSubEvents[type] && this.nrOfSubEvents[type] < 65535);
        this.jitSubEvents[type] = JitSubEventMethodInlinedImpl.read(reader, this.nrOfSubEvents[type], mapInfo);
    }

    private void checkInlining(ProfilingPrintStream stream) {
        JitSubEventMethodInlinedImpl[] inliningEvents = (JitSubEventMethodInlinedImpl[])this.jitSubEvents[JitSubEventBaseImpl.JIT_SUBEVENT_COMP_METHOD_INLINED];
        if (inliningEvents.length == 0) {
            return;
        }
        int[] seenBciAtDepth = new int[50];
        byte curDepth = 0;
        for (int ii = 0; ii < inliningEvents.length; ++ii) {
            JitSubEventMethodInlinedImpl curEvent = inliningEvents[ii];
            if (curEvent.getInliningDepth() > curDepth) {
                curDepth = curEvent.getInliningDepth();
                seenBciAtDepth[curDepth] = curEvent.getCallerBci();
                continue;
            }
            if (curEvent.getInliningDepth() > curDepth) continue;
            curDepth = curEvent.getInliningDepth();
            if (curEvent.getCallerBci() < seenBciAtDepth[curDepth]) {
                stream.println("ERROR: non monotonic bcis");
                stream.println("inlining event: " + curEvent);
                break;
            }
            seenBciAtDepth[curDepth] = curEvent.getCallerBci();
        }
    }

    public static ProfilingPacketImpl read(PacketResourceReader reader, MappingInformation mapInfo) throws IOException {
        JitEventMethodCompilationImpl result = new JitEventMethodCompilationImpl(reader, mapInfo);
        mapInfo.addJitCompilationEvent(result);
        return result;
    }

    private void printEvents(ProfilingPrintStream stream) {
        int type = JitSubEventBaseImpl.JIT_SUBEVENT_COMP_METHOD_INLINED;
        if (this.nrOfSubEvents[type] > 0) {
            JitSubEventMethodInlinedImpl[] subEvents = (JitSubEventMethodInlinedImpl[])this.jitSubEvents[type];
            JitSubEventMethodInlinedImpl.printHeader(stream);
            for (int ii = 0; ii < this.nrOfSubEvents[type]; ++ii) {
                subEvents[ii].print(stream);
            }
        }
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.println("compile id                    : " + this.compileId);
        stream.formatln("compiled method               : %*M", this.compiledMethod);
        stream.println("tier                          : " + this.getCompilationLevel());
        if (this.isOSR()) {
            stream.println("osr entry bci                 : " + this.getEntryBci());
        }
        stream.formatln("timestamp                     : %*A", this.getTimestamp());
        if (this.compilationFailed()) {
            stream.println("failed with reason            : " + this.failureMsg + " (ciEnv: " + this.ciEnvfailureMsg + ")");
        }
        this.printEvents(stream);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)920);
        super.write(writer);
        writer.writeCompressedInt32(this.compileId);
        writer.writeMethodObject(this.compiledMethod);
        writer.writeInt8(this.bitfield);
        if (this.isOSR()) {
            writer.writeUint16((char)this.getEntryBci());
        }
        if (this.compilationFailed()) {
            writer.writeUTF(this.failureMsg);
            writer.writeUTF(this.ciEnvfailureMsg);
        }
        int type = JitSubEventBaseImpl.JIT_SUBEVENT_COMP_METHOD_INLINED;
        writer.writeUint16((char)this.nrOfSubEvents[type]);
        JitSubEventBaseImpl[] inliningSubEvents = this.jitSubEvents[type];
        for (int ii = 0; ii < this.nrOfSubEvents[type]; ++ii) {
            inliningSubEvents[ii].write(writer);
        }
        writer.finalizePacket();
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.JIT_COMPILATION_EVENT;
    }

    @Override
    public MethodObject getMethod() {
        return this.compiledMethod;
    }

    @Override
    public int getCompileId() {
        return this.compileId;
    }

    @Override
    public int getEntryBci() {
        assert (this.isOSR());
        return this.entryBci;
    }

    @Override
    public boolean isOSR() {
        return (this.bitfield >> 4 & IS_OSR_MASK) != 0;
    }

    @Override
    public boolean compilationFailed() {
        return (this.bitfield >> 0 & COMP_FAILED_MASK) == 1;
    }

    @Override
    public UTF8String getFailureMsg() {
        return this.failureMsg;
    }

    @Override
    public UTF8String getCiEnvFailureMsg() {
        return this.ciEnvfailureMsg;
    }

    @Override
    public int getCompilationLevel() {
        return this.bitfield >> 1 & COMP_LEVEL_MASK;
    }

    public JitSubEventBaseImpl[] getEvents(int eventType) {
        return this.jitSubEvents[eventType];
    }

    public JitSubEventMethodInlinedImpl[] getInliningEvents() {
        return (JitSubEventMethodInlinedImpl[])this.getEvents(JitSubEventBaseImpl.JIT_SUBEVENT_COMP_METHOD_INLINED);
    }

    private static int right_n_bits(int n) {
        return JitEventMethodCompilationImpl.nth_bit(n) - 1;
    }

    private static int nth_bit(int n) {
        return n >= 32 ? 0 : 1 << n;
    }

    @Override
    public String getPacketName() {
        return "JIT Compilation Event";
    }
}

