/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.jit.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.jit.event.JitEventBaseImpl;
import com.sap.jvm.profiling.impl.jit.event.JitEventMethodCompilationImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.jit.event.JitEventMethodCompilation;
import com.sap.jvm.profiling.jit.event.JitEventNMethodStateChange;
import com.sap.jvm.profiling.jit.event.NMethodState;
import com.sap.jvm.profiling.resource.PacketResourceReader;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import java.io.IOException;

public final class JitEventNMethodStateChangeImpl
extends JitEventBaseImpl
implements JitEventNMethodStateChange {
    private MethodObject method;
    private JitEventMethodCompilationImpl compilation;
    private int compileId;
    private NMethodState newState;

    public JitEventNMethodStateChangeImpl(PacketResourceReader reader, MappingInformation mapInfo) throws IOException {
        super(reader);
        this.method = reader.readMethodObject();
        this.compileId = reader.readCompressedInt32();
        assert (this.compileId > 0 && this.compileId < 500000);
        boolean isOSR = reader.readBoolean();
        byte newStateRaw = reader.readInt8();
        switch (newStateRaw) {
            case 0: {
                this.newState = NMethodState.IN_USE;
                break;
            }
            case 1: {
                this.newState = NMethodState.NOT_ENTRANT;
                break;
            }
            case 2: {
                this.newState = NMethodState.ZOMBIE;
                break;
            }
            case 3: {
                this.newState = NMethodState.UNLOADED;
                break;
            }
            case 4: {
                this.newState = NMethodState.NOT_USED;
                break;
            }
            case -1: {
                this.newState = NMethodState.UNKNOWN;
                break;
            }
            default: {
                assert (false);
                this.newState = NMethodState.UNKNOWN;
            }
        }
        this.compilation = mapInfo.getJitCompilationEvent(this.compileId, isOSR);
        if (this.method == null && this.compilation != null) {
            this.method = this.compilation.getMethod();
        }
        assert (null == this.compilation || this.method == null || this.method.equals(this.compilation.getMethod()));
    }

    public static ProfilingPacketImpl read(PacketResourceReader reader, MappingInformation mapInfo) throws IOException {
        JitEventNMethodStateChangeImpl result = new JitEventNMethodStateChangeImpl(reader, mapInfo);
        return result;
    }

    @Override
    public MethodObject getMethod() {
        return this.method;
    }

    @Override
    public NMethodState getNewState() {
        return this.newState;
    }

    @Override
    public int getCompileId() {
        return this.compileId;
    }

    @Override
    public JitEventMethodCompilation getCompilationEvent() {
        return this.compilation;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.JIT_NMETHOD_STATE_CHANGE_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.println("method                        : " + this.method);
        stream.println("new state                     : " + (Object)((Object)this.newState));
        stream.println("compile id                    : " + this.compileId);
        stream.println("tier                          : " + (null == this.compilation ? "n/a" : Integer.valueOf(this.compilation.getCompilationLevel())));
        if (null == this.compilation || this.compilation.isOSR()) {
            stream.println("osr entry bci                 : " + (null == this.compilation ? "n/a" : Integer.valueOf(this.compilation.getEntryBci())));
        }
        stream.formatln("timestamp                     : %*A", this.getTimestamp());
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        int newStateRaw;
        writer.initializePacket((short)921);
        super.write(writer);
        writer.writeMethodObject(this.method);
        writer.writeCompressedInt32(this.getCompileId());
        writer.writeBoolean(null == this.compilation ? false : this.compilation.isOSR());
        switch (this.newState) {
            case IN_USE: {
                newStateRaw = 0;
                break;
            }
            case NOT_ENTRANT: {
                newStateRaw = 1;
                break;
            }
            case ZOMBIE: {
                newStateRaw = 2;
                break;
            }
            case UNLOADED: {
                newStateRaw = 3;
                break;
            }
            case NOT_USED: {
                newStateRaw = 4;
                break;
            }
            case UNKNOWN: {
                newStateRaw = -1;
                break;
            }
            default: {
                assert (false);
                newStateRaw = -1;
            }
        }
        writer.writeInt8(newStateRaw);
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "JIT NMethod State Change Event";
    }
}

