/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.jit.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.impl.jit.event.JitSubEventBaseImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.jit.event.JitSubEventMethodInlined;
import com.sap.jvm.profiling.resource.PacketResourceReader;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import java.io.IOException;

public class JitSubEventMethodInlinedImpl
extends JitSubEventBaseImpl
implements JitSubEventMethodInlined {
    private MethodObject inlinedMethod;
    private char callerBci;
    private byte inliningDepth;

    public JitSubEventMethodInlinedImpl(MethodObject inlinedMethod, char callerBci, byte depth) {
        this.inlinedMethod = inlinedMethod;
        this.callerBci = callerBci;
        this.inliningDepth = depth;
    }

    @Override
    protected void print(ProfilingPrintStream stream) {
        for (int ii = 0; ii < this.inliningDepth; ++ii) {
            stream.print(". ");
        }
        stream.formatln("@%d %*M", this.callerBci, this.inlinedMethod);
    }

    public static JitSubEventBaseImpl[] read(PacketResourceReader reader, int nrOfEvents, MappingInformation mapInfo) throws IOException {
        JitSubEventBaseImpl[] events = new JitSubEventMethodInlinedImpl[nrOfEvents];
        for (int ii = 0; ii < nrOfEvents; ++ii) {
            MethodObject inlinedMethod = reader.readMethodObject();
            char callerBci = reader.readUint16();
            assert ('\u0000' <= callerBci && callerBci < '\u2710');
            short depth = reader.readUint8();
            assert (0 <= depth && depth < 20);
            events[ii] = new JitSubEventMethodInlinedImpl(inlinedMethod, callerBci, (byte)depth);
        }
        return events;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.writeMethodObject(this.inlinedMethod);
        writer.writeUint16(this.callerBci);
        writer.writeInt8(this.inliningDepth);
    }

    @Override
    public MethodObject getInlinedMethod() {
        return this.inlinedMethod;
    }

    @Override
    public char getCallerBci() {
        return this.callerBci;
    }

    @Override
    public byte getInliningDepth() {
        return this.inliningDepth;
    }

    protected static void printHeader(ProfilingPrintStream stream) {
        stream.println("inlining                      : ");
    }
}

