/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.memory.GcHistoryFileDump;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.util.io.FileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;

public final class GcHistoryFileDumpImpl
implements GcHistoryFileDump {
    final String name;
    private final long size;
    private final byte[] buffer;
    private final long timeStampMilli;
    private final long timeStampNano;

    public GcHistoryFileDumpImpl(ResourceReader reader) throws IOException {
        this.name = reader.readString();
        this.size = reader.readInt64();
        this.buffer = new byte[(int)this.size];
        reader.readBytes(this.buffer, 0, (int)this.size);
        this.timeStampNano = reader.readInt64();
        this.timeStampMilli = reader.readInt64();
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        int toWrite;
        writer.writeString(this.name);
        writer.writeInt64(this.size);
        int off = 0;
        for (int left = this.buffer.length; left > 0; left -= toWrite) {
            toWrite = Math.min(left, 32768);
            writer.writeBytes(this.buffer, off, toWrite);
            off += toWrite;
        }
        writer.writeInt64(this.timeStampNano);
        writer.writeInt64(this.timeStampMilli);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.println("GC History File Dump");
        stream.println("Name  :" + this.name);
        stream.println("Size  :" + this.size);
        stream.print(", endTime=" + new Date(this.timeStampMilli));
    }

    @Override
    public File saveToFile(File fileToBeUsed) throws IOException {
        File sink = fileToBeUsed;
        if (!sink.exists() && !sink.createNewFile() || !sink.canWrite()) {
            throw new IllegalArgumentException("File " + sink + " cannot be written.");
        }
        if (sink.exists()) {
            sink.delete();
        }
        FileOutputStream fos = new FileOutputStream(sink);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        bos.write(this.buffer);
        bos.close();
        return sink;
    }

    @Override
    public long sizeOfDump() {
        return this.size;
    }

    @Override
    public long getDumpTime() {
        return this.timeStampMilli;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public String getFileName() {
        return FileUtils.getSafeFileName(this.name);
    }
}

