/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.command;

import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.command.CommandType;
import com.sap.jvm.profiling.impl.core.command.CommandImpl;
import com.sap.jvm.profiling.memory.command.EnableAllocationMptTraceCommand;
import com.sap.jvm.profiling.method.command.RequestedMethodParameter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public final class EnableAllocationMptTraceCommandImpl
extends CommandImpl
implements EnableAllocationMptTraceCommand {
    private final int maxStackTraceSize;
    private final boolean includeLineNrs;
    private final boolean assignObjectId;
    private final boolean isSilent;
    private final String classFilter;
    private final ThreadFilter threadFilter;
    private boolean allowPacketReordering;
    private boolean allowMultiEvents;
    private final boolean hideStringResolving;
    private final boolean hideFinalizerAllocation;
    private final boolean hideStaticInitializers;
    private final boolean hideClassLoading;
    private final ArrayList<RequestedMethodParameter> specs;
    private final boolean includeTimeStamp;
    private final boolean includeCpuTime;
    private final boolean includeStackTrace;
    private final boolean includeStackTraceInExitEvents;
    private final int traceEveryNth;
    private final boolean onlyTopPhysicalFrame;
    private final boolean includeInlineCount;
    private final boolean useBci;
    private final boolean useNonZeroBci;
    private final boolean supportJRuby;

    EnableAllocationMptTraceCommandImpl(int maxStackTraceSize, boolean includeLineNrs, boolean assignObjectId, boolean isSilent, String classFilter, ThreadFilter threadFilter, boolean allowPacketReordering, boolean allowMultiEvents, boolean hideStringResolving, boolean hideFinalizerAllocation, boolean hideStaticInitializers, boolean hideClassLoading, List<RequestedMethodParameter> methodSpecs, boolean includeTimeStamp, boolean includeCpuTime, boolean includeStackTrace, boolean includeStackTraceInExitEvents, int traceEveryNth, boolean onlyTopPhysicalFrame, boolean includeInlineCount, boolean useBci, boolean useNonZeroBci, boolean supportJRuby) {
        this.maxStackTraceSize = maxStackTraceSize;
        this.includeLineNrs = includeLineNrs;
        this.assignObjectId = assignObjectId;
        this.isSilent = isSilent;
        this.classFilter = classFilter;
        this.threadFilter = threadFilter;
        this.allowPacketReordering = allowPacketReordering;
        this.allowMultiEvents = allowMultiEvents;
        this.hideStringResolving = hideStringResolving;
        this.hideFinalizerAllocation = hideFinalizerAllocation;
        this.hideStaticInitializers = hideStaticInitializers;
        this.hideClassLoading = hideClassLoading;
        this.specs = new ArrayList<RequestedMethodParameter>(methodSpecs);
        this.includeTimeStamp = includeTimeStamp;
        this.includeCpuTime = includeCpuTime;
        this.includeStackTrace = includeStackTrace;
        this.includeStackTraceInExitEvents = includeStackTraceInExitEvents;
        this.traceEveryNth = traceEveryNth;
        this.onlyTopPhysicalFrame = onlyTopPhysicalFrame;
        this.includeInlineCount = includeInlineCount;
        this.useBci = useBci;
        this.useNonZeroBci = useNonZeroBci;
        this.supportJRuby = supportJRuby;
        if (maxStackTraceSize < -1) {
            throw new IllegalArgumentException("Illegal value of maxStackTraceSize: " + maxStackTraceSize);
        }
        if (isSilent && !assignObjectId) {
            throw new IllegalArgumentException("If isSilent is true, assignObjectId must be true too");
        }
    }

    @Override
    public void print(PrintStream stream) {
        stream.print("Enable allocation mpt trace (maxStackTraceSize: ");
        stream.print(this.maxStackTraceSize);
        stream.print(", includeLineNrs: ");
        stream.print(this.includeLineNrs);
        stream.print(", assignObjectId: ");
        stream.print(this.assignObjectId);
        stream.print(", isSilent: ");
        stream.print(this.isSilent);
        stream.print(", classFilter: ");
        stream.print(this.classFilter == null ? "**" : this.classFilter);
        stream.print(", threadFilter: ");
        stream.print(this.threadFilter == null ? "**" : this.threadFilter.asString());
        stream.print(", allowPacketReordering: ");
        stream.print(this.allowPacketReordering);
        stream.print(", allowMultiEvents: ");
        stream.print(this.allowMultiEvents);
        stream.print(", hideStringResolving: ");
        stream.print(this.hideStringResolving);
        stream.print(", hideFinalizerAllocation: ");
        stream.print(this.hideFinalizerAllocation);
        stream.print(", hideStaticInitializers: ");
        stream.print(this.hideStaticInitializers);
        stream.print(", hideClassLoading");
        stream.print(this.hideClassLoading);
        stream.print(", include time stamps: " + this.includeTimeStamp);
        stream.print(", include CPU time: " + this.includeCpuTime);
        stream.print(", include stack trace: " + this.includeStackTrace);
        stream.print(", include stack trace in exit events: " + this.includeStackTraceInExitEvents);
        stream.print(", trace_every_nth: " + this.traceEveryNth);
        stream.print(", onlyTopPhysicalFrame: " + this.onlyTopPhysicalFrame);
        stream.print(", includeInlineCount: " + this.includeInlineCount);
        stream.print(", useBci: " + this.useBci);
        stream.print(", useNonZeroBci: " + this.useNonZeroBci);
        stream.print(", supportJRuby: " + this.supportJRuby);
        stream.println(')');
    }

    @Override
    protected void writeToStreamImpl(DataOutputStream stream) throws IOException {
        this.writeUint16(stream, 37);
        stream.writeLong(this.getId());
        stream.writeInt(this.maxStackTraceSize);
        stream.writeBoolean(this.includeLineNrs);
        stream.writeBoolean(this.assignObjectId);
        stream.writeBoolean(this.isSilent);
        this.writeClassFilter(stream, this.classFilter);
        this.writeNewThreadFilter(stream, this.threadFilter);
        stream.writeBoolean(this.hideStringResolving);
        stream.writeBoolean(this.hideFinalizerAllocation);
        stream.writeBoolean(this.hideStaticInitializers);
        stream.writeBoolean(this.hideClassLoading);
        stream.writeBoolean(this.allowPacketReordering);
        stream.writeBoolean(this.allowMultiEvents);
        stream.writeInt(this.specs.size());
        stream.writeBoolean(this.includeTimeStamp);
        stream.writeBoolean(this.includeCpuTime);
        stream.writeBoolean(this.includeStackTrace);
        for (RequestedMethodParameter spec : this.specs) {
            stream.writeUTF(spec.getName());
            stream.writeUTF(spec.getDescription());
            stream.writeUTF(spec.getMethod());
            stream.writeByte(spec.getIncludeType().getType());
            stream.writeInt(spec.getIndex());
            List<String> modifiers = spec.getModifiers();
            stream.writeInt(modifiers.size());
            for (String modifier : modifiers) {
                stream.writeUTF(modifier);
            }
        }
        stream.writeInt(this.traceEveryNth);
        stream.writeBoolean(this.onlyTopPhysicalFrame);
        stream.writeBoolean(this.includeInlineCount);
        stream.writeBoolean(this.useBci);
        stream.writeBoolean(this.useNonZeroBci);
        stream.writeBoolean(this.supportJRuby);
        stream.writeBoolean(this.includeStackTraceInExitEvents);
    }

    @Override
    public CommandType getType() {
        return CommandType.ENABLE_ALLOCATION_MPT_TRACE;
    }
}

