/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.command;

import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.command.CommandType;
import com.sap.jvm.profiling.impl.core.command.CommandImpl;
import com.sap.jvm.profiling.memory.command.EnableAllocationTraceCommand;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class EnableAllocationTraceCommandImpl
extends CommandImpl
implements EnableAllocationTraceCommand {
    private final int maxStackTraceSize;
    private final boolean includeLineNrs;
    private final boolean assignObjectId;
    private final boolean isSilent;
    private final String classFilter;
    private final ThreadFilter threadFilter;
    private boolean allowPacketReordering;
    private boolean allowMultiEvents;
    private final boolean hideStringResolving;
    private final boolean hideFinalizerAllocation;
    private final boolean hideStaticInitializers;
    private final boolean hideClassLoading;
    private final int traceEveryNth;
    private final boolean onlyTopPhysicalFrame;
    private final boolean includeInlineCount;
    private final boolean useBci;
    private final boolean useNonZeroBci;
    private final boolean supportJRuby;

    EnableAllocationTraceCommandImpl(int maxStackTraceSize, boolean includeLineNrs, boolean assignObjectId, boolean isSilent, String classFilter, ThreadFilter threadFilter, boolean allowPacketReordering, boolean allowMultiEvents, boolean hideStringResolving, boolean hideFinalizerAllocation, boolean hideStaticInitializers, boolean hideClassLoading, int traceEveryNth, boolean onlyTopPhysicalFrame, boolean includeInlineCount, boolean useBci, boolean useNonZeroBci, boolean supportJRuby) throws IllegalArgumentException {
        this.maxStackTraceSize = maxStackTraceSize;
        this.includeLineNrs = includeLineNrs;
        this.assignObjectId = assignObjectId;
        this.isSilent = isSilent;
        this.classFilter = classFilter;
        this.threadFilter = threadFilter;
        this.allowPacketReordering = allowPacketReordering;
        this.allowMultiEvents = allowMultiEvents;
        this.hideStringResolving = hideStringResolving;
        this.hideFinalizerAllocation = hideFinalizerAllocation;
        this.hideStaticInitializers = hideStaticInitializers;
        this.hideClassLoading = hideClassLoading;
        this.traceEveryNth = traceEveryNth;
        this.onlyTopPhysicalFrame = onlyTopPhysicalFrame;
        this.includeInlineCount = includeInlineCount;
        this.useBci = useBci;
        this.useNonZeroBci = useNonZeroBci;
        this.supportJRuby = supportJRuby;
        if (maxStackTraceSize < -1) {
            throw new IllegalArgumentException("Illegal value of maxStackTraceSize: " + maxStackTraceSize);
        }
        if (isSilent && !assignObjectId) {
            throw new IllegalArgumentException("If isSilent is true, assignObjectId must be true too");
        }
    }

    @Override
    public void print(PrintStream stream) {
        stream.print("Enable allocation trace (maxStackTraceSize: ");
        stream.print(this.maxStackTraceSize);
        stream.print(", includeLineNrs: ");
        stream.print(this.includeLineNrs);
        stream.print(", assignObjectId: ");
        stream.print(this.assignObjectId);
        stream.print(", isSilent: ");
        stream.print(this.isSilent);
        stream.print(", classFilter: ");
        stream.print(this.classFilter == null ? "**" : this.classFilter);
        stream.print(", threadFilter: ");
        stream.print(this.threadFilter == null ? "**" : this.threadFilter.asString());
        stream.print(", allowPacketReordering: ");
        stream.print(this.allowPacketReordering);
        stream.print(", allowMultiEvents: ");
        stream.print(this.allowMultiEvents);
        stream.print(", hideStringResolving: ");
        stream.print(this.hideStringResolving);
        stream.print(", hideFinalizerAllocation: ");
        stream.print(this.hideFinalizerAllocation);
        stream.print(", hideStaticInitializers: ");
        stream.print(this.hideStaticInitializers);
        stream.print(", hideClassLoading");
        stream.print(this.hideClassLoading);
        stream.print(", traceEveryNth: ");
        stream.print(this.traceEveryNth);
        stream.print(", onlyTopPhysicalFrame: ");
        stream.print(this.onlyTopPhysicalFrame);
        stream.print(", includeInlineCount: " + this.includeInlineCount);
        stream.print(", useBci: " + this.useBci);
        stream.print(", useNonZeroBci: " + this.useNonZeroBci);
        stream.print(", supportJRuby: " + this.supportJRuby);
        stream.println(')');
    }

    @Override
    protected void writeToStreamImpl(DataOutputStream stream) throws IOException {
        this.writeUint16(stream, 14);
        stream.writeLong(this.getId());
        stream.writeInt(this.maxStackTraceSize);
        stream.writeBoolean(this.includeLineNrs);
        stream.writeBoolean(this.assignObjectId);
        stream.writeBoolean(this.isSilent);
        this.writeClassFilter(stream, this.classFilter);
        this.writeThreadFilter(stream, this.threadFilter);
        stream.writeBoolean(this.hideStringResolving);
        stream.writeBoolean(this.hideFinalizerAllocation);
        stream.writeBoolean(this.hideStaticInitializers);
        stream.writeBoolean(this.hideClassLoading);
        stream.writeBoolean(this.allowPacketReordering);
        stream.writeBoolean(this.allowMultiEvents);
        this.writeNewThreadFilter(stream, this.threadFilter);
        stream.writeInt(this.traceEveryNth);
        stream.writeBoolean(this.onlyTopPhysicalFrame);
        stream.writeBoolean(this.includeInlineCount);
        stream.writeBoolean(this.useBci);
        stream.writeBoolean(this.useNonZeroBci);
        stream.writeBoolean(this.supportJRuby);
    }

    @Override
    public CommandType getType() {
        return CommandType.ENABLE_ALLOCATION_TRACE;
    }
}

