/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.command;

import com.sap.jvm.profiling.impl.core.command.CommandImpl;
import com.sap.jvm.profiling.memory.AgeRange;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

abstract class EnableClassStatCommandBaseImpl
extends CommandImpl {
    private final AgeRange[] ageRanges;

    protected EnableClassStatCommandBaseImpl(AgeRange ageRange) {
        this(new AgeRange[]{ageRange});
    }

    protected EnableClassStatCommandBaseImpl(AgeRange[] ageRanges) {
        if (ageRanges == null) {
            throw new IllegalArgumentException("The parameter \"ageRanges is null.");
        }
        for (int i = 0; i < ageRanges.length; ++i) {
            if (ageRanges[i] != null) continue;
            throw new IllegalArgumentException("One of the elements within the \"ageRanges\" array is null.");
        }
        this.ageRanges = ageRanges;
    }

    @Override
    public void print(PrintStream stream) {
        stream.println("(age ranges = ");
        if (this.ageRanges != null) {
            stream.print("age ranges = ");
            for (int i = 0; i < this.ageRanges.length; ++i) {
                if (i == 0) {
                    stream.print("(");
                } else {
                    stream.print(" (");
                }
                stream.print(this.ageRanges[i].getLowerLimit());
                stream.print(",");
                stream.print(this.ageRanges[i].getUpperLimit());
                stream.println(")");
            }
        } else {
            stream.print("no age ranges");
        }
        stream.print(this.getAdditionalPrintContent());
        stream.println(')');
    }

    protected String getAdditionalPrintContent() {
        return "";
    }

    @Override
    protected void writeToStreamImpl(DataOutputStream stream) throws IOException {
        this.writeUint16(stream, this.getTypeTag());
        stream.writeLong(this.getId());
        if (this.ageRanges != null) {
            this.writeUint16(stream, this.ageRanges.length);
            for (int i = 0; i < this.ageRanges.length; ++i) {
                stream.writeInt(this.ageRanges[i].getLowerLimit());
                stream.writeInt(this.ageRanges[i].getUpperLimit());
            }
        } else {
            this.writeUint16(stream, 0);
        }
    }

    protected int getAdditionalSize() {
        return 0;
    }

    protected abstract int getTypeTag();
}

