/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.command;

import com.sap.jvm.profiling.core.command.CommandType;
import com.sap.jvm.profiling.impl.memory.command.EnableClassStatCommandBaseImpl;
import com.sap.jvm.profiling.memory.AgeRange;
import com.sap.jvm.profiling.memory.command.EnableYoungGenClassStatCommand;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class EnableYoungGenClassStatCommandImpl
extends EnableClassStatCommandBaseImpl
implements EnableYoungGenClassStatCommand {
    private final boolean onlyOnFullGC;

    public EnableYoungGenClassStatCommandImpl(boolean onlyOnFullGCs, AgeRange ageRange) {
        this(onlyOnFullGCs, new AgeRange[]{ageRange});
    }

    public EnableYoungGenClassStatCommandImpl(boolean onlyOfFullGC, AgeRange[] ageRanges) {
        super(ageRanges);
        this.onlyOnFullGC = onlyOfFullGC;
    }

    @Override
    public CommandType getType() {
        return CommandType.ENABLE_YOUNG_GEN_CLASS_STAT_TRACE;
    }

    @Override
    public void print(PrintStream stream) {
        stream.println("Enable young gen class statistic ");
        super.print(stream);
    }

    @Override
    protected String getAdditionalPrintContent() {
        return ", [onlyOnFullGCs=" + Boolean.toString(this.onlyOnFullGC);
    }

    @Override
    protected int getAdditionalSize() {
        return 1;
    }

    @Override
    protected void writeToStreamImpl(DataOutputStream stream) throws IOException {
        super.writeToStreamImpl(stream);
        stream.writeByte(this.onlyOnFullGC ? 1 : 0);
    }

    @Override
    protected int getTypeTag() {
        return 6;
    }
}

