/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.command;

import com.sap.jvm.profiling.core.command.CommandType;
import com.sap.jvm.profiling.impl.core.command.CommandImpl;
import com.sap.jvm.profiling.memory.command.HprofDumpCommand;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class HprofDumpCommandImpl
extends CommandImpl
implements HprofDumpCommand {
    private final String name;
    private final boolean includeAddons;
    private final boolean ensureIdsForAllObjects;
    private final boolean forceGc;

    public HprofDumpCommandImpl(String name, boolean includeAddons, boolean ensureIdsForAllObjects, boolean forceGc) {
        this.name = name;
        this.includeAddons = includeAddons;
        this.ensureIdsForAllObjects = ensureIdsForAllObjects;
        this.forceGc = forceGc;
    }

    @Override
    public CommandType getType() {
        return CommandType.HPROF_DUMP;
    }

    @Override
    public void print(PrintStream stream) {
        stream.print("Hprof dump: name=" + this.name);
        stream.print(", includeAddons=" + this.includeAddons);
        stream.print(", ensureIdsForAllObjects=" + this.ensureIdsForAllObjects);
        stream.print(", forceGc=" + this.forceGc);
        stream.println();
    }

    @Override
    protected void writeToStreamImpl(DataOutputStream stream) throws IOException {
        this.writeUint16(stream, 59);
        stream.writeLong(this.getId());
        stream.writeUTF(this.name);
        stream.writeBoolean(this.includeAddons);
        stream.writeBoolean(this.ensureIdsForAllObjects);
        stream.writeBoolean(this.forceGc);
    }
}

