/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.memory.event.AllocationEvent;

public abstract class AbstractAllocationEventImpl
extends ProfilingPacketImpl
implements AllocationEvent {
    protected AbstractAllocationEventImpl() {
    }

    @Override
    public final void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Class              : %*C", this.getClassObject());
        stream.formatln("Object id          : %d", this.getObjectId());
        stream.formatln("Size               : %*B", this.getSize());
        if (this.getClassObject().isArrayClass()) {
            stream.formatln("Length             : %d", this.getLength());
        }
        if (this.getNrOfAllocations() > 1) {
            stream.formatln("Nr. of allocations : %d", this.getNrOfAllocations());
        }
        stream.formatln("Thread             : %*T", this.getThreadIndex());
        stream.formatln("Stack trace        : %*S", this.getStackTraceIndex());
        stream.formatln("Inlined top frames : %d", this.getNrOfInlinedTopFrames());
    }

    @Override
    public boolean isStackAllocation() {
        return false;
    }

    @Override
    public boolean isHeapAllocation() {
        return !this.isStackAllocation();
    }
}

