/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.memory.event.ClassStatisticDumpEnd;
import com.sap.jvm.profiling.memory.event.ClassStatisticEventHandler;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;
import java.util.Date;

public class ClassStatisticDumpEndImpl
extends ProfilingPacketImpl
implements ClassStatisticDumpEnd {
    private final String name;
    private final long timestamp;
    private final long endTime;

    public static ClassStatisticDumpEndImpl read(ResourceReader reader, ClassStatisticEventHandler[] handlers) throws IOException {
        ClassStatisticDumpEndImpl response = new ClassStatisticDumpEndImpl(reader);
        for (ClassStatisticEventHandler handler : handlers) {
            handler.handle(response);
        }
        return response;
    }

    private ClassStatisticDumpEndImpl(ResourceReader reader) throws IOException {
        this.name = reader.readString();
        this.timestamp = reader.readInt64();
        this.endTime = reader.readInt64();
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.DUMP_CLASS_STATISTIC_END_RESPONSE;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.print("class statistic end: name=" + this.name);
        stream.format(", timestamp=%*t", this.timestamp);
        stream.print(", startTime=" + new Date(this.endTime));
        stream.println();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)698);
        writer.writeString(this.name);
        writer.writeInt64(this.timestamp);
        writer.writeInt64(this.endTime);
        writer.finalizePacket();
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public String getPacketName() {
        return "class statistic end event";
    }
}

