/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.memory.event.ClassStatisticDumpStart;
import com.sap.jvm.profiling.memory.event.ClassStatisticEventHandler;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;
import java.util.Date;

public class ClassStatisticDumpStartImpl
extends ProfilingPacketImpl
implements ClassStatisticDumpStart {
    private final String name;
    private final long timestamp;
    private final long startTime;

    public static ClassStatisticDumpStartImpl read(ResourceReader reader, ClassStatisticEventHandler[] handlers) throws IOException {
        ClassStatisticDumpStartImpl response = new ClassStatisticDumpStartImpl(reader);
        for (ClassStatisticEventHandler handler : handlers) {
            handler.handle(response);
        }
        return response;
    }

    private ClassStatisticDumpStartImpl(ResourceReader reader) throws IOException {
        this.name = reader.readString();
        this.timestamp = reader.readInt64();
        this.startTime = reader.readInt64();
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.DUMP_CLASS_STATISTIC_START_RESPONSE;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.print("hprof dump start: name=" + this.name);
        stream.format(", timestamp=%*t", this.timestamp);
        stream.print(", startTime=" + new Date(this.startTime));
        stream.println();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)698);
        writer.writeString(this.name);
        writer.writeInt64(this.timestamp);
        writer.writeInt64(this.startTime);
        writer.finalizePacket();
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public String getPacketName() {
        return "class statistic start event";
    }
}

