/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GCHistoryInitialValuesImpl
implements GCHistoryInitialValues {
    private final int numberOfGCThreads;
    private final int numberOfConcurrentGCThreads;
    private final long reservedJavaHeapSize;
    private final long reservedPermGenSize;
    private final long maxClassSpaceSize;
    private final int pauseTimeTargetMs;
    private final long heapRegionSize;
    private final int maxHeapRegionNum;
    private final int rsetUpdatingPauseTimePercent;
    private long currentGCNr = 0L;
    private boolean keyGC = false;
    private long currentFullGCNr = 0L;
    private final long startTimestamp;
    private final int keyGCDistance;
    private final double[] systemLoadAverageThresholds;
    private final int maxObjectAge;
    private final int nrOfFullGcsBeforeCompaction;
    private final int minObjectSize;
    private final boolean exact;
    private long cumulativeDuration = 0L;
    private long cumulativeCpuTime = 0L;
    private long cumulativePageFaults = 0L;
    private long cumulativeMajorPageFaults = 0L;
    private long cumulativeMinorPageFaults = 0L;
    private long cumulativeNrOfUnloadedNonArrayClasses = 0L;
    private long cumulativeNrOfUnloadedArrayClasses = 0L;
    private long cumulativeBytesAllocatedInPerm = 0L;
    private long cumulativeBytesFreedInPerm = 0L;
    private long cumulativeBytesAllocatedInNonPerm = 0L;
    private long cumulativeBytesFreedInNonPerm = 0L;
    private long clearedSoftRefsSum = 0L;
    private long enqueuedSoftRefsSum = 0L;
    private long clearedWeakRefsSum = 0L;
    private long enqueuedWeakRefsSum = 0L;
    private long enqueuedFinalRefsSum = 0L;
    private long enqueuedPhantomRefsSum = 0L;
    private long bytesUsedInPermAfterGC = 0L;
    private long bytesUsedInNonPermAfterGC = 0L;
    private long nrOfArrayClassesAfterLastGc = 0L;
    private long nrOfNonArrayClassesAfterLastGc = 0L;
    private List<ByteArrayBasicResourceReader> gcEvents = new ArrayList<ByteArrayBasicResourceReader>();
    private List<Integer> gcEventTypes = new ArrayList<Integer>();
    private boolean cumulativeAssertionsEnabled = true;
    private boolean hasSeenKeyPacket;

    public GCHistoryInitialValuesImpl(ResourceReader reader) throws IOException {
        this.numberOfGCThreads = reader.readInt32();
        this.numberOfConcurrentGCThreads = reader.readInt32();
        this.reservedJavaHeapSize = reader.readInt64();
        this.reservedPermGenSize = reader.readInt64();
        this.startTimestamp = reader.readInt64();
        this.keyGCDistance = reader.readInt32();
        this.maxObjectAge = reader.readUint8();
        this.nrOfFullGcsBeforeCompaction = reader.readInt32();
        this.minObjectSize = reader.readUint8();
        this.systemLoadAverageThresholds = new double[32];
        for (int i = 0; i < this.systemLoadAverageThresholds.length; ++i) {
            this.systemLoadAverageThresholds[i] = reader.readFloat();
        }
        this.exact = reader.hasNext() ? reader.readBoolean() : false;
        this.maxClassSpaceSize = reader.hasNext() ? reader.readInt64() : 0L;
        if (reader.hasNext()) {
            this.pauseTimeTargetMs = reader.readInt32();
            this.rsetUpdatingPauseTimePercent = reader.readInt32();
            this.heapRegionSize = reader.readInt64();
            this.maxHeapRegionNum = reader.readInt32();
        } else {
            this.pauseTimeTargetMs = 0;
            this.rsetUpdatingPauseTimePercent = 0;
            this.heapRegionSize = 0L;
            this.maxHeapRegionNum = 0;
        }
        if (reader.hasNext()) {
            this.hasSeenKeyPacket = reader.readBoolean();
        }
    }

    private GCHistoryInitialValuesImpl(GCHistoryInitialValuesImpl gcHistoryValues) {
        this.numberOfGCThreads = gcHistoryValues.numberOfGCThreads;
        this.numberOfConcurrentGCThreads = gcHistoryValues.numberOfConcurrentGCThreads;
        this.reservedJavaHeapSize = gcHistoryValues.reservedJavaHeapSize;
        this.reservedPermGenSize = gcHistoryValues.reservedPermGenSize;
        this.startTimestamp = gcHistoryValues.startTimestamp;
        this.keyGCDistance = gcHistoryValues.keyGCDistance;
        this.maxObjectAge = gcHistoryValues.maxObjectAge;
        this.nrOfFullGcsBeforeCompaction = gcHistoryValues.nrOfFullGcsBeforeCompaction;
        this.minObjectSize = gcHistoryValues.minObjectSize;
        this.systemLoadAverageThresholds = new double[gcHistoryValues.systemLoadAverageThresholds.length];
        System.arraycopy(gcHistoryValues.systemLoadAverageThresholds, 0, this.systemLoadAverageThresholds, 0, this.systemLoadAverageThresholds.length);
        this.exact = gcHistoryValues.exact;
        this.maxClassSpaceSize = gcHistoryValues.maxClassSpaceSize;
        this.pauseTimeTargetMs = gcHistoryValues.pauseTimeTargetMs;
        this.rsetUpdatingPauseTimePercent = gcHistoryValues.rsetUpdatingPauseTimePercent;
        this.heapRegionSize = gcHistoryValues.heapRegionSize;
        this.maxHeapRegionNum = gcHistoryValues.maxHeapRegionNum;
    }

    @Override
    public int getNumberOfGCThreads() {
        return this.numberOfGCThreads;
    }

    @Override
    public int getNumberOfConcurrentGCThreads() {
        return this.numberOfConcurrentGCThreads;
    }

    @Override
    public long getReservedPermGenSize() {
        return this.reservedPermGenSize;
    }

    @Override
    public long getReservedJavaHeapSize() {
        return this.reservedJavaHeapSize;
    }

    @Override
    public long getMaxClassSpaceSize() {
        return this.maxClassSpaceSize;
    }

    @Override
    public int getPauseTimeTargetMs() {
        return this.pauseTimeTargetMs;
    }

    @Override
    public int getRsetUpdatingPauseTimePercent() {
        return this.rsetUpdatingPauseTimePercent;
    }

    @Override
    public long getHeapRegionSize() {
        return this.heapRegionSize;
    }

    @Override
    public int getMaxHeapRegionNum() {
        return this.maxHeapRegionNum;
    }

    @Override
    public long getGCNr() {
        return this.currentGCNr;
    }

    @Override
    public void setGCNr(long newNr, boolean forcedKeyGC) {
        assert (newNr >= this.currentGCNr);
        this.currentGCNr = newNr;
        this.keyGC = forcedKeyGC;
        this.hasSeenKeyPacket |= this.keyGC;
    }

    @Override
    public boolean isKeyGC() {
        return this.currentGCNr % (long)this.keyGCDistance == 0L || this.keyGC;
    }

    @Override
    public long getFullGCNr() {
        return this.currentFullGCNr;
    }

    @Override
    public void setFullGCNr(long newNr) {
        assert (newNr >= this.currentFullGCNr);
        this.currentFullGCNr = newNr;
    }

    @Override
    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public long getClearedSoftRefsSum() {
        return this.clearedSoftRefsSum;
    }

    @Override
    public long getClearedWeakRefsSum() {
        return this.clearedWeakRefsSum;
    }

    @Override
    public long getCumulativeBytesAllocatedInNonPerm() {
        return this.cumulativeBytesAllocatedInNonPerm;
    }

    @Override
    public long getCumulativeBytesAllocatedInPerm() {
        return this.cumulativeBytesAllocatedInPerm;
    }

    @Override
    public long getCumulativeBytesFreedInNonPerm() {
        return this.cumulativeBytesFreedInNonPerm;
    }

    @Override
    public long getCumulativeBytesFreedInPerm() {
        return this.cumulativeBytesFreedInPerm;
    }

    @Override
    public long getCumulativeCpuTime() {
        return this.cumulativeCpuTime;
    }

    @Override
    public long getCumulativeDuration() {
        return this.cumulativeDuration;
    }

    @Override
    public long getCumulativeMajorPageFaults() {
        return this.cumulativeMajorPageFaults;
    }

    @Override
    public long getCumulativeMinorPageFaults() {
        return this.cumulativeMinorPageFaults;
    }

    @Override
    public long getCumulativeNrOfUnloadedArrayClasses() {
        return this.cumulativeNrOfUnloadedArrayClasses;
    }

    @Override
    public long getCumulativeNrOfUnloadedNonArrayClasses() {
        return this.cumulativeNrOfUnloadedNonArrayClasses;
    }

    @Override
    public long getCumulativePageFaults() {
        return this.cumulativePageFaults;
    }

    @Override
    public long getEnqueuedFinalRefsSum() {
        return this.enqueuedFinalRefsSum;
    }

    @Override
    public long getEnqueuedPhantomRefsSum() {
        return this.enqueuedPhantomRefsSum;
    }

    @Override
    public long getEnqueuedSoftRefsSum() {
        return this.enqueuedSoftRefsSum;
    }

    @Override
    public long getEnqueuedWeakRefsSum() {
        return this.enqueuedWeakRefsSum;
    }

    @Override
    public void setClearedSoftRefsSum(long refs) {
        this.clearedSoftRefsSum = refs;
    }

    @Override
    public void setClearedWeakRefsSum(long refs) {
        this.clearedWeakRefsSum = refs;
    }

    @Override
    public void setCumulativeBytesAllocatedInNonPerm(long allocated) {
        this.cumulativeBytesAllocatedInNonPerm = allocated;
    }

    @Override
    public void setCumulativeBytesAllocatedInPerm(long allocated) {
        assert (!this.cumulativeAssertionsEnabled || (double)allocated >= (double)this.cumulativeBytesAllocatedInPerm * 0.8);
        this.cumulativeBytesAllocatedInPerm = allocated;
    }

    @Override
    public void setCumulativeBytesFreedInNonPerm(long freed) {
        assert (!this.cumulativeAssertionsEnabled || (double)freed >= (double)this.cumulativeBytesFreedInNonPerm * 0.8);
        this.cumulativeBytesFreedInNonPerm = freed;
    }

    @Override
    public void setCumulativeBytesFreedInPerm(long freed) {
        assert (!this.cumulativeAssertionsEnabled || (double)freed >= (double)this.cumulativeBytesFreedInPerm * 0.8);
        this.cumulativeBytesFreedInPerm = freed;
    }

    @Override
    public void setCumulativeCpuTime(long cpuTime) {
        assert (cpuTime / 1000L >= this.cumulativeCpuTime / 1000L);
        this.cumulativeCpuTime = cpuTime;
    }

    @Override
    public void setCumulativeDuration(long duration) {
        assert (duration / 1000L >= this.cumulativeDuration / 1000L);
        this.cumulativeDuration = duration;
    }

    @Override
    public void setCumulativeMajorPageFaults(long pageFaults) {
        assert (pageFaults >= this.cumulativeMajorPageFaults);
        this.cumulativeMajorPageFaults = pageFaults;
    }

    @Override
    public void setCumulativeMinorPageFaults(long pageFaults) {
        assert (pageFaults >= this.cumulativeMinorPageFaults);
        this.cumulativeMinorPageFaults = pageFaults;
    }

    @Override
    public void setCumulativeNrOfUnloadedArrayClasses(long nrOfClasses) {
        assert (nrOfClasses >= this.cumulativeNrOfUnloadedArrayClasses);
        this.cumulativeNrOfUnloadedArrayClasses = nrOfClasses;
    }

    @Override
    public void setCumulativeNrOfUnloadedNonArrayClasses(long nrOfClasses) {
        assert (nrOfClasses >= this.cumulativeNrOfUnloadedNonArrayClasses);
        this.cumulativeNrOfUnloadedNonArrayClasses = nrOfClasses;
    }

    @Override
    public void setCumulativePageFaults(long pageFaults) {
        assert (pageFaults >= this.cumulativePageFaults);
        this.cumulativePageFaults = pageFaults;
    }

    @Override
    public void setEnqueuedFinalRefsSum(long refs) {
        this.enqueuedFinalRefsSum = refs;
    }

    @Override
    public void setEnqueuedPhantomRefsSum(long refs) {
        this.enqueuedPhantomRefsSum = refs;
    }

    @Override
    public void setEnqueuedSoftRefsSum(long refs) {
        this.enqueuedSoftRefsSum = refs;
    }

    @Override
    public void setEnqueuedWeakRefsSum(long refs) {
        this.enqueuedWeakRefsSum = refs;
    }

    @Override
    public void addGCEvent(ResourceReader reader, int type, MappingInformation mapInfo) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while (reader.hasNext()) {
            bos.write(reader.readInt8());
        }
        ByteArrayBasicResourceReader r = new ByteArrayBasicResourceReader(bos.toByteArray());
        this.gcEvents.add(r);
        this.gcEventTypes.add(type);
    }

    @Override
    public void clearGCEvents() {
        this.gcEvents.clear();
        this.gcEventTypes.clear();
    }

    @Override
    public ByteArrayBasicResourceReader[] getGCEvents() {
        return this.gcEvents.toArray(new ByteArrayBasicResourceReader[this.gcEvents.size()]);
    }

    @Override
    public int[] getGCEventTypes() {
        int[] result = new int[this.gcEventTypes.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.gcEventTypes.get(i);
        }
        return result;
    }

    @Override
    public long getBytesUsedInNonPermAfterGC() {
        return this.bytesUsedInNonPermAfterGC;
    }

    @Override
    public long getBytesUsedInPermAfterGC() {
        return this.bytesUsedInPermAfterGC;
    }

    @Override
    public void setBytesUsedInNonPermAfterGC(long used) {
        this.bytesUsedInNonPermAfterGC = used;
    }

    @Override
    public void setBytesUsedInPermAfterGC(long used) {
        this.bytesUsedInPermAfterGC = used;
    }

    @Override
    public double[] readSystemLoadAverage(ByteArrayBasicResourceReader reader) throws EOFException {
        double[] result = new double[3];
        if (!reader.hasNext(2)) {
            result[0] = -1.0;
            result[1] = -1.0;
            result[2] = -1.0;
            return result;
        }
        int compressedLoadAverage = reader.readInt16();
        if ((compressedLoadAverage & 0x8000) != 0) {
            result[0] = -1.0;
            result[1] = -1.0;
            result[2] = -1.0;
        } else {
            int mask = 31;
            int i = 0;
            while (i < 3) {
                result[i] = this.systemLoadAverageThresholds[compressedLoadAverage & 0x1F];
                ++i;
                compressedLoadAverage >>= 5;
            }
        }
        return result;
    }

    @Override
    public int getMaxObjectAge() {
        return this.maxObjectAge;
    }

    @Override
    public int getNrOfFullGcsBeforeCompaction() {
        return this.nrOfFullGcsBeforeCompaction;
    }

    @Override
    public int getMinObjectSize() {
        return this.minObjectSize;
    }

    @Override
    public long getNrOfArrayClassesAfterLastGc() {
        return this.nrOfArrayClassesAfterLastGc;
    }

    @Override
    public long getNrOfNonArrayClassesAfterLastGc() {
        return this.nrOfNonArrayClassesAfterLastGc;
    }

    @Override
    public void setNrOfArrayClassesAfterLastGc(long nrOfArrayClasses) {
        this.nrOfArrayClassesAfterLastGc = nrOfArrayClasses;
    }

    @Override
    public void setNrOfNonArrayClassesAfterLastGc(long nrOfNonArrayClasses) {
        this.nrOfNonArrayClassesAfterLastGc = nrOfNonArrayClasses;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)414);
        writer.writeInt32(this.numberOfGCThreads);
        writer.writeInt32(this.numberOfConcurrentGCThreads);
        writer.writeInt64(this.reservedJavaHeapSize);
        writer.writeInt64(this.reservedPermGenSize);
        writer.writeInt64(this.startTimestamp);
        writer.writeInt32(this.keyGCDistance);
        writer.writeInt8(this.maxObjectAge);
        writer.writeInt32(this.nrOfFullGcsBeforeCompaction);
        writer.writeInt8(this.minObjectSize);
        assert (this.systemLoadAverageThresholds.length == 32);
        for (int i = 0; i < this.systemLoadAverageThresholds.length; ++i) {
            writer.writeFloat((float)this.systemLoadAverageThresholds[i]);
        }
        writer.writeBoolean(this.exact);
        writer.writeInt64(this.maxClassSpaceSize);
        writer.writeInt32(this.pauseTimeTargetMs);
        writer.writeInt32(this.rsetUpdatingPauseTimePercent);
        writer.writeInt64(this.heapRegionSize);
        writer.writeInt32(this.maxHeapRegionNum);
        writer.writeBoolean(this.hasSeenKeyPacket);
        writer.finalizePacket();
    }

    @Override
    public GCHistoryInitialValues copy() {
        return new GCHistoryInitialValuesImpl(this);
    }

    @Override
    public boolean isExact() {
        return this.exact;
    }

    @Override
    public void enableCumulativeValueAssertions(boolean enable) {
        this.cumulativeAssertionsEnabled = enable;
    }

    @Override
    public boolean hasSeenKeyPacket() {
        return this.hasSeenKeyPacket;
    }
}

