/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GcEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcDurationEventBase;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public abstract class GcDurationEventBaseImpl
extends GcEventBaseImpl
implements GcDurationEventBase {
    private long duration;
    private long cpuTime;
    private long pageFaults;
    private long majorPageFaults;
    private long minorPageFaults;

    public GcDurationEventBaseImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.formatln("Duration                                : %.2f ms", (double)this.duration / 1000.0);
        stream.formatln("CPU time                                : %.2f ms", (double)this.cpuTime / 1000.0);
        stream.println("Page faults                             : " + this.pageFaults);
        stream.println("Major page faults                       : " + this.majorPageFaults);
        stream.println("Minor page faults                       : " + this.minorPageFaults);
    }

    protected void readDurationsAndPageFaults(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        boolean exact = statistic.isExact();
        this.duration = reader.readScaledInt32(1000L, exact);
        this.cpuTime = reader.readScaledInt32(1000L, exact);
        this.pageFaults = reader.readCompressedInt32();
        this.majorPageFaults = reader.readCompressedInt32();
        this.minorPageFaults = reader.readCompressedInt32();
    }

    @Override
    public long getCpuTime() {
        return this.cpuTime;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public long getPageFaults() {
        return this.pageFaults;
    }

    @Override
    public long getMajorPageFaults() {
        return this.majorPageFaults;
    }

    @Override
    public long getMinorPageFaults() {
        return this.minorPageFaults;
    }
}

