/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.SimpleProfilingPrintStream;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventBase;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.tracing.Trace;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public abstract class GcEventBaseImpl
implements GcEventBase {
    private long timestamp;
    private final byte[] packetData;
    private final byte ver;

    protected GcEventBaseImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        this.packetData = reader.getBytes();
        assert (mapInfo.getSession().getSystemInfo().gcStatisticVersion() < 127);
        this.ver = (byte)mapInfo.getSession().getSystemInfo().gcStatisticVersion();
    }

    public void print(ProfilingPrintStream stream) {
        stream.println("GC event name                           : " + this.getGcEventType().getDescription());
        stream.println("Event start time                        : " + new Date(this.timestamp));
    }

    public final String toString() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SimpleProfilingPrintStream pps = new SimpleProfilingPrintStream(bos);
        this.print(pps);
        pps.close();
        try {
            return I18n.forceSanitize(new String(bos.toByteArray(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Trace.warn((Throwable)e, "No UTF8?");
            return e.getMessage();
        }
    }

    protected void readTimestamp(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        this.timestamp = reader.readCompressedInt64() + statistic.getTimestamp();
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    protected void writeInternal(ResourceWriter writer) throws IOException {
        writer.writeInt32(this.packetData.length);
        writer.writeBytes(this.packetData);
    }

    public int ver() {
        return this.ver;
    }
}

