/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GcDurationEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventClassunloadingPhase1;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public class GcEventClassunloadingPhase1Impl
extends GcDurationEventBaseImpl
implements GcEventClassunloadingPhase1 {
    private final long nrOfNonArrayClassesBefore;
    private final long nrOfNonArrayClassesAfter;
    private final long nrOfArrayClassesBefore;
    private final long nrOfArrayClassesAfter;

    public GcEventClassunloadingPhase1Impl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.readDurationsAndPageFaults(reader, mapInfo, statistic);
        this.nrOfNonArrayClassesBefore = reader.readCompressedInt64();
        this.nrOfNonArrayClassesAfter = reader.readCompressedInt64();
        this.nrOfArrayClassesBefore = reader.readCompressedInt64();
        this.nrOfArrayClassesAfter = reader.readCompressedInt64();
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.CLASSUNLOADING_PHASE1;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.println("Nr. of non-array classes before event   : " + this.nrOfNonArrayClassesBefore);
        stream.println("Nr. of non-array classes after event    : " + this.nrOfNonArrayClassesAfter);
        stream.println("Nr. of unloaded non-array classes       : " + (this.nrOfNonArrayClassesAfter - this.nrOfNonArrayClassesBefore));
        stream.println("Nr. of array classes before event       : " + this.nrOfArrayClassesBefore);
        stream.println("Nr. of array classes after event        : " + this.nrOfArrayClassesAfter);
        stream.println("Nr. of unloaded array classes           : " + (this.nrOfArrayClassesAfter - this.nrOfArrayClassesBefore));
    }

    @Override
    public long getNrOfNonArrayClassesBefore() {
        return this.nrOfNonArrayClassesBefore;
    }

    @Override
    public long getNrOfNonArrayClassesAfter() {
        return this.nrOfNonArrayClassesAfter;
    }

    @Override
    public long getNrOfArrayClassesBefore() {
        return this.nrOfArrayClassesBefore;
    }

    @Override
    public long getNrOfArrayClassesAfter() {
        return this.nrOfArrayClassesAfter;
    }
}

