/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GcDurationEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventClassunloadingPhase2;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public class GcEventClassunloadingPhase2Impl
extends GcDurationEventBaseImpl
implements GcEventClassunloadingPhase2 {
    private final long metaspaceUsedBefore;
    private final long metaspaceUsedAfter;
    private final long metaspaceCommittedBefore;
    private final long metaspaceCommittedAfter;
    private final long classSpaceUsedBefore;
    private final long classSpaceUsedAfter;
    private final long classSpaceCommittedBefore;
    private final long classSpaceCommittedAfter;

    public GcEventClassunloadingPhase2Impl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.readDurationsAndPageFaults(reader, mapInfo, statistic);
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        boolean exact = statistic.isExact();
        this.metaspaceCommittedBefore = reader.readInt64Percentage(history.getReservedPermGenSize(), exact);
        this.metaspaceCommittedAfter = reader.readInt64Percentage(history.getReservedPermGenSize(), exact);
        this.metaspaceUsedBefore = reader.readInt64Percentage(this.metaspaceCommittedBefore, exact);
        this.metaspaceUsedAfter = reader.readInt64Percentage(this.metaspaceCommittedAfter, exact);
        this.classSpaceCommittedBefore = reader.readInt64Percentage(history.getMaxClassSpaceSize(), exact);
        this.classSpaceCommittedAfter = reader.readInt64Percentage(history.getMaxClassSpaceSize(), exact);
        this.classSpaceUsedBefore = reader.readInt64Percentage(this.classSpaceCommittedBefore, exact);
        this.classSpaceUsedAfter = reader.readInt64Percentage(this.classSpaceCommittedAfter, exact);
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.CLASSUNLOADING_PHASE2;
    }

    private void printSpace(ProfilingPrintStream stream, String memType, String spaceName, long usedBefore, long usedAfter) {
        stream.formatln("%-40s: %*B", memType + " in " + spaceName + " before event", usedBefore);
        stream.formatln("%-40s: %*B", memType + " in " + spaceName + " after event", usedAfter);
        long freed = usedBefore - usedAfter;
        stream.formatln("%-40s: %*B", "Difference in " + spaceName, freed);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        this.printSpace(stream, "Used", "metaspace", this.metaspaceUsedBefore, this.metaspaceUsedAfter);
        this.printSpace(stream, "Committed", "metaspace", this.metaspaceCommittedBefore, this.metaspaceCommittedAfter);
        this.printSpace(stream, "Used", "class space", this.classSpaceUsedBefore, this.classSpaceUsedAfter);
        this.printSpace(stream, "Committed", "class space", this.classSpaceCommittedBefore, this.classSpaceCommittedAfter);
    }

    @Override
    public long getMetaspaceUsedBefore() {
        return this.metaspaceUsedBefore;
    }

    @Override
    public long getMetaspaceUsedAfter() {
        return this.metaspaceUsedAfter;
    }

    @Override
    public long getMetaspaceCommittedBefore() {
        return this.metaspaceCommittedBefore;
    }

    @Override
    public long getMetaspaceCommittedAfter() {
        return this.metaspaceCommittedAfter;
    }

    @Override
    public long getClassSpaceUsedBefore() {
        return this.classSpaceUsedBefore;
    }

    @Override
    public long getClassSpaceUsedAfter() {
        return this.classSpaceUsedAfter;
    }

    @Override
    public long getClassSpaceCommittedBefore() {
        return this.classSpaceCommittedBefore;
    }

    @Override
    public long getClassSpaceCommittedAfter() {
        return this.classSpaceCommittedAfter;
    }
}

