/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GcEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventCmsAborted;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public final class GcEventCmsAbortedImpl
extends GcEventBaseImpl
implements GcEventCmsAborted {
    private final int fullGcsSinceConcGc;
    private final int fullGcsBeforeCompaction;
    private final boolean isUserRequested;
    private final boolean incrementalCollectionWillFail;
    private final boolean clearSoftRefs;

    public GcEventCmsAbortedImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        this.fullGcsSinceConcGc = reader.readCompressedInt32();
        this.fullGcsBeforeCompaction = history.getNrOfFullGcsBeforeCompaction();
        boolean[] bools = reader.readBooleanArray();
        this.isUserRequested = bools[0];
        this.incrementalCollectionWillFail = bools[1];
        this.clearSoftRefs = bools[2];
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.println("Nr. of full GCs since last conc. GC     : " + this.fullGcsSinceConcGc);
        stream.println("Max. nr of full GCs before compaction   : " + this.fullGcsBeforeCompaction);
        stream.println("GC was user requested                   : " + (this.isUserRequested ? "yes" : "no"));
        stream.println("Young gen GC expected to fail           : " + (this.incrementalCollectionWillFail ? "yes" : "no"));
        stream.println("Forced clearing of soft references      : " + (this.clearSoftRefs ? "yes" : "no"));
    }

    @Override
    public int getFullGcsSinceConcGc() {
        return this.fullGcsSinceConcGc;
    }

    @Override
    public int getFullGcsBeforeCompaction() {
        return this.fullGcsBeforeCompaction;
    }

    @Override
    public boolean isUserRequested() {
        return this.isUserRequested;
    }

    @Override
    public boolean isIncrementalCollectionWillFail() {
        return this.incrementalCollectionWillFail;
    }

    @Override
    public boolean isClearSoftRefs() {
        return this.clearSoftRefs;
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.CMS_ABORTED;
    }
}

