/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GcDurationEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventCmsFinalMarking;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public final class GcEventCmsFinalMarkingImpl
extends GcDurationEventBaseImpl
implements GcEventCmsFinalMarking {
    private final int nrOfThreads;
    private final long nrOfCardsCleaned;
    private final long nrOfNonArrayClassesUnloaded;
    private final long nrOfArrayClassesUnloaded;
    private final boolean isRemarkingParallel;
    private final boolean isReferenceProcessingParallel;
    private final long remarkingDuration;
    private final long remarkingCpuTime;
    private final long classUnloadingDuration;
    private final long classUnloadingCpuTime;
    private final long symbolUnloadingDuration;
    private final long symbolUnloadingCpuTime;
    private final long referenceHandlingDuration;
    private final long referenceHandlingCpuTime;
    private final long referenceEqueueingDuration;
    private final long referenceEqueueingCpuTime;
    private final long successfulSteals;
    private final long failedSteals;
    private final long successfulOverflowRefills;
    private final long successfulOverflowRefillObjects;
    private final long failedOverflowRefills;
    private final long failedStealsWithYield;
    private final double[] systemLoadAverage;
    private final double[] virtualCpuUtilization;

    public GcEventCmsFinalMarkingImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.readDurationsAndPageFaults(reader, mapInfo, statistic);
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        boolean exact = statistic.isExact();
        this.nrOfCardsCleaned = reader.readCompressedInt64();
        this.nrOfNonArrayClassesUnloaded = this.ver() < 1 ? reader.readCompressedInt64() : 0L;
        this.nrOfArrayClassesUnloaded = this.ver() < 1 ? reader.readCompressedInt64() : 0L;
        boolean[] bools = reader.readBooleanArray();
        this.isRemarkingParallel = bools[0];
        this.isReferenceProcessingParallel = bools[1];
        this.nrOfThreads = this.isRemarkingParallel || this.isReferenceProcessingParallel ? history.getNumberOfGCThreads() : 1;
        this.remarkingDuration = reader.readScaledInt32(1000L, exact);
        this.remarkingCpuTime = reader.readScaledInt32(1000L, exact);
        this.classUnloadingDuration = this.ver() < 1 ? reader.readScaledInt32(1000L, exact) : 0L;
        this.classUnloadingCpuTime = this.ver() < 1 ? reader.readScaledInt32(1000L, exact) : 0L;
        this.symbolUnloadingDuration = reader.readScaledInt32(1000L, exact);
        this.symbolUnloadingCpuTime = reader.readScaledInt32(1000L, exact);
        this.referenceHandlingDuration = reader.readScaledInt32(1000L, exact);
        this.referenceHandlingCpuTime = reader.readScaledInt32(1000L, exact);
        this.referenceEqueueingDuration = this.ver() < 3 ? reader.readScaledInt32(1000L, exact) : 0L;
        this.referenceEqueueingCpuTime = this.ver() < 3 ? reader.readScaledInt32(1000L, exact) : 0L;
        this.successfulSteals = reader.readCompressedInt32();
        this.failedSteals = reader.readCompressedInt32();
        this.successfulOverflowRefills = reader.readCompressedInt32();
        this.successfulOverflowRefillObjects = reader.readCompressedInt32();
        this.failedOverflowRefills = reader.readCompressedInt32();
        this.failedStealsWithYield = reader.readCompressedInt32();
        this.systemLoadAverage = history.readSystemLoadAverage(reader);
        this.virtualCpuUtilization = history.readSystemLoadAverage(reader);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.println("Remarking was parallel                  : " + (this.isRemarkingParallel ? "yes" : "no"));
        stream.println("Number of parallel threads              : " + this.nrOfThreads);
        stream.println("Number of cards cleaned                 : " + this.nrOfCardsCleaned);
        stream.println("Reference processing was parallel       : " + (this.isReferenceProcessingParallel ? "yes" : "no"));
        if (this.ver() < 1) {
            stream.println("Non-array classes unloaded              : " + this.nrOfNonArrayClassesUnloaded);
            stream.println("Array classes unloaded                  : " + this.nrOfArrayClassesUnloaded);
        }
        stream.println("Number of successful steal operations   : " + this.successfulSteals);
        stream.println("Number of failed steal operations       : " + this.failedSteals);
        stream.println("Number of successful overflow refills   : " + this.successfulOverflowRefills);
        stream.println("Number of objs from overflow refills    : " + this.successfulOverflowRefillObjects);
        stream.println("Number of failed overflow refills       : " + this.failedOverflowRefills);
        stream.println("Number of failed steals and yields      : " + this.failedStealsWithYield);
        stream.formatln("Remarking duration                      : %.2f ms", (double)this.remarkingDuration / 1000.0);
        stream.formatln("Remarking CPU time                      : %.2f ms", (double)this.remarkingCpuTime / 1000.0);
        if (this.ver() < 1) {
            stream.formatln("Class unloading duration                : %.2f ms", (double)this.classUnloadingDuration / 1000.0);
            stream.formatln("Class unloading CPU time                : %.2f ms", (double)this.classUnloadingCpuTime / 1000.0);
        }
        stream.formatln("Symbol unloading duration               : %.2f ms", (double)this.symbolUnloadingDuration / 1000.0);
        stream.formatln("Symbol unloading CPU time               : %.2f ms", (double)this.symbolUnloadingCpuTime / 1000.0);
        stream.formatln("Reference processing duration           : %.2f ms", (double)this.referenceHandlingDuration / 1000.0);
        stream.formatln("Reference processing CPU time           : %.2f ms", (double)this.referenceHandlingCpuTime / 1000.0);
        if (this.ver() < 3) {
            stream.formatln("Reference enqueueing duration           : %.2f ms", (double)this.referenceEqueueingDuration / 1000.0);
            stream.formatln("Reference enqueueing CPU time           : %.2f ms", (double)this.referenceEqueueingCpuTime / 1000.0);
        }
        stream.formatln("System load average                     : %.2f, %.2f, %.2f", this.systemLoadAverage[0], this.systemLoadAverage[1], this.systemLoadAverage[2]);
        stream.formatln("Host CPU utilization (virtualized)      : %.2f, %.2f, %.2f", this.virtualCpuUtilization[0], this.virtualCpuUtilization[1], this.virtualCpuUtilization[2]);
    }

    @Override
    public long getNrOfArrayClassesUnloaded() {
        return this.nrOfArrayClassesUnloaded;
    }

    @Override
    public long getNrOfCardsCleaned() {
        return this.nrOfCardsCleaned;
    }

    @Override
    public long getNrOfNonArrayClassesUnloaded() {
        return this.nrOfNonArrayClassesUnloaded;
    }

    @Override
    public int getNrOfThreads() {
        return this.nrOfThreads;
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.CMS_FINAL_MARKING;
    }

    @Override
    public long getClassUnloadingCpuTime() {
        return this.classUnloadingCpuTime;
    }

    @Override
    public long getClassUnloadingDuration() {
        return this.classUnloadingDuration;
    }

    @Override
    public long getFailedOverflowRefills() {
        return this.failedOverflowRefills;
    }

    @Override
    public long getFailedSteals() {
        return this.failedSteals;
    }

    @Override
    public long getFailedStealsWithYield() {
        return this.failedStealsWithYield;
    }

    @Override
    public long getReferenceEqueueingCpuTime() {
        return this.referenceHandlingCpuTime;
    }

    @Override
    public long getReferenceEqueueingDuration() {
        return this.referenceEqueueingDuration;
    }

    @Override
    public long getReferenceHandlingCpuTime() {
        return this.referenceHandlingCpuTime;
    }

    @Override
    public long getReferenceHandlingDuration() {
        return this.referenceHandlingDuration;
    }

    @Override
    public long getRemarkingCpuTime() {
        return this.remarkingCpuTime;
    }

    @Override
    public long getRemarkingDuration() {
        return this.remarkingDuration;
    }

    @Override
    public long getSuccessfulOverflowRefillObjects() {
        return this.successfulOverflowRefillObjects;
    }

    @Override
    public long getSuccessfulOverflowRefills() {
        return this.successfulOverflowRefills;
    }

    @Override
    public long getSuccessfulSteals() {
        return this.successfulSteals;
    }

    @Override
    public long getSymbolUnloadingCpuTime() {
        return this.symbolUnloadingCpuTime;
    }

    @Override
    public long getSymbolUnloadingDuration() {
        return this.symbolUnloadingDuration;
    }

    @Override
    public double[] getSystemLoadAverage() {
        return (double[])this.systemLoadAverage.clone();
    }

    @Override
    public boolean isReferenceProcessingParallel() {
        return this.isReferenceProcessingParallel;
    }

    @Override
    public boolean isRemarkingParallel() {
        return this.isRemarkingParallel;
    }

    @Override
    public double[] getVirtualCpuUtilization() {
        return (double[])this.virtualCpuUtilization.clone();
    }

    @Override
    public boolean isConcurrent() {
        return false;
    }
}

