/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GcDurationEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventCmsInitialMarking;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public final class GcEventCmsInitialMarkingImpl
extends GcDurationEventBaseImpl
implements GcEventCmsInitialMarking {
    private final long bytesInOld;
    private final long committedBytesInOld;
    private final long permUsed;
    private final long permCommitted;
    private final long nrOfNonArrayClasses;
    private final long nrOfArrayClasses;
    private final double[] systemLoadAverage;
    private final double[] virtualCpuUtilization;
    private final int nrOfThreads;
    private final boolean isParallel;

    public GcEventCmsInitialMarkingImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.readDurationsAndPageFaults(reader, mapInfo, statistic);
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        boolean exact = statistic.isExact();
        this.bytesInOld = reader.readInt64Percentage(statistic.getMaxOldGenSize(), exact);
        this.committedBytesInOld = reader.readInt64InvPercentage(statistic.getMaxOldGenSize(), exact);
        this.permUsed = reader.readInt64Percentage(history.getReservedPermGenSize(), exact);
        this.permCommitted = reader.readInt64InvPercentage(history.getReservedPermGenSize(), exact);
        this.nrOfNonArrayClasses = reader.readCompressedInt64();
        this.nrOfArrayClasses = reader.readCompressedInt64();
        this.systemLoadAverage = history.readSystemLoadAverage(reader);
        this.virtualCpuUtilization = history.readSystemLoadAverage(reader);
        boolean[] bools = reader.hasNext() ? reader.readBooleanArray() : new boolean[8];
        this.isParallel = bools[0];
        this.nrOfThreads = this.isParallel ? history.getNumberOfGCThreads() : 1;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.println("Initial marking was parallel            : " + (this.isParallel ? "yes" : "no"));
        stream.println("Number of parallel threads              : " + this.nrOfThreads);
        stream.formatln("Used in old gen before event            : %*B", this.bytesInOld);
        stream.formatln("Committed in old gen before event       : %*B", this.committedBytesInOld);
        stream.formatln("Used in perm gen before event           : %*B", this.permUsed);
        stream.formatln("Committed in perm gen before event      : %*B", this.permCommitted);
        stream.println("Non-array classes loaded before event   : " + this.nrOfNonArrayClasses);
        stream.println("Array classes loaded before event       : " + this.nrOfArrayClasses);
        stream.formatln("System load average                     : %.2f, %.2f, %.2f", this.systemLoadAverage[0], this.systemLoadAverage[1], this.systemLoadAverage[2]);
        stream.formatln("Host CPU utilization (virtualized)      : %.2f, %.2f, %.2f", this.virtualCpuUtilization[0], this.virtualCpuUtilization[1], this.virtualCpuUtilization[2]);
    }

    @Override
    public long getBytesInOld() {
        return this.bytesInOld;
    }

    @Override
    public long getCommittedBytesInOld() {
        return this.committedBytesInOld;
    }

    @Override
    public long getPermUsed() {
        return this.permUsed;
    }

    @Override
    public long getPermCommitted() {
        return this.permCommitted;
    }

    @Override
    public long getNrOfNonArrayClasses() {
        return this.nrOfNonArrayClasses;
    }

    @Override
    public long getNrOfArrayClasses() {
        return this.nrOfArrayClasses;
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.CMS_INITIAL_MARKING;
    }

    @Override
    public double[] getSystemLoadAverage() {
        return (double[])this.systemLoadAverage.clone();
    }

    @Override
    public double[] getVirtualCpuUtilization() {
        return (double[])this.virtualCpuUtilization.clone();
    }

    @Override
    public int getNrOfThreads() {
        return this.nrOfThreads;
    }

    @Override
    public boolean isParallel() {
        return this.isParallel;
    }

    @Override
    public boolean isConcurrent() {
        return false;
    }
}

