/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GcDurationEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventCmsMarking;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public final class GcEventCmsMarkingImpl
extends GcDurationEventBaseImpl
implements GcEventCmsMarking {
    private final boolean isConcurrent;
    private final boolean isParallel;
    private final int nrOfGcThreads;
    private final long successfulSteals;
    private final long failedSteals;
    private final long successfulOverflowRefills;
    private final long successfulOverflowRefillObjects;
    private final long failedOverflowRefills;
    private final long failedStealsWithYield;

    public GcEventCmsMarkingImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.readDurationsAndPageFaults(reader, mapInfo, statistic);
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        boolean[] bools = reader.readBooleanArray();
        this.isConcurrent = bools[0];
        this.isParallel = bools[1];
        this.nrOfGcThreads = history.getNumberOfConcurrentGCThreads();
        this.successfulSteals = reader.readCompressedInt32();
        this.failedSteals = reader.readCompressedInt32();
        this.successfulOverflowRefills = reader.readCompressedInt32();
        this.successfulOverflowRefillObjects = reader.readCompressedInt32();
        this.failedOverflowRefills = reader.readCompressedInt32();
        this.failedStealsWithYield = reader.readCompressedInt32();
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.println("Marking was concurrent                  : " + (this.isConcurrent ? "yes" : "no"));
        stream.println("Marking was parallel                    : " + (this.isParallel ? "yes" : "no"));
        stream.println("Number of parallel marking threads      : " + this.nrOfGcThreads);
        stream.println("Number of successful steal operations   : " + this.successfulSteals);
        stream.println("Number of failed steal operations       : " + this.failedSteals);
        stream.println("Number of successful overflow refills   : " + this.successfulOverflowRefills);
        stream.println("Number of objects from overflow refills : " + this.successfulOverflowRefillObjects);
        stream.println("Number of failed overflow refills       : " + this.failedOverflowRefills);
        stream.println("Number of failed steals and yields      : " + this.failedStealsWithYield);
    }

    @Override
    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.CMS_MARKING;
    }

    @Override
    public long getFailedOverflowRefills() {
        return this.failedOverflowRefills;
    }

    @Override
    public long getFailedSteals() {
        return this.failedSteals;
    }

    @Override
    public long getFailedStealsWithYield() {
        return this.failedStealsWithYield;
    }

    @Override
    public int getNrOfGcThreads() {
        return this.nrOfGcThreads;
    }

    @Override
    public long getSuccessfulOverflowRefillObjects() {
        return this.successfulOverflowRefillObjects;
    }

    @Override
    public long getSuccessfulOverflowRefills() {
        return this.successfulOverflowRefills;
    }

    @Override
    public long getSuccessfulSteals() {
        return this.successfulSteals;
    }

    @Override
    public boolean isParallel() {
        return this.isParallel;
    }
}

