/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GcDurationEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventCmsPrecleaning;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public final class GcEventCmsPrecleaningImpl
extends GcDurationEventBaseImpl
implements GcEventCmsPrecleaning {
    private final long nrOfCardsCleaned;
    private final int softReferencesFoundInPreprocessing;
    private final int deadSoftReferencesFoundInPreprocessing;
    private final int softReferencesResurrectedInPreprocessing;

    public GcEventCmsPrecleaningImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.readDurationsAndPageFaults(reader, mapInfo, statistic);
        this.nrOfCardsCleaned = reader.readCompressedInt64();
        this.softReferencesFoundInPreprocessing = reader.readCompressedInt32();
        this.deadSoftReferencesFoundInPreprocessing = reader.readCompressedInt32();
        this.softReferencesResurrectedInPreprocessing = reader.readCompressedInt32();
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.println("Number of cards cleaned                 : " + this.nrOfCardsCleaned);
        stream.println("Nr. of SoftRefs found (preprocessing)   : " + this.softReferencesFoundInPreprocessing);
        stream.println("Nr. of dead SoftRefs found (preproc.)   : " + this.deadSoftReferencesFoundInPreprocessing);
        stream.println("Nr. of dead SoftRefs resurrected (pp.)  : " + this.softReferencesResurrectedInPreprocessing);
    }

    @Override
    public long getNrOfCardsCleaned() {
        return this.nrOfCardsCleaned;
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.CMS_PRECLEANING;
    }

    @Override
    public int getDeadSoftReferencesFoundInPreprocessing() {
        return this.deadSoftReferencesFoundInPreprocessing;
    }

    @Override
    public int getSoftReferencesFoundInPreprocessing() {
        return this.softReferencesFoundInPreprocessing;
    }

    @Override
    public int getSoftReferencesResurrectedInPreprocessing() {
        return this.softReferencesResurrectedInPreprocessing;
    }

    @Override
    public boolean isConcurrent() {
        return true;
    }
}

