/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GcDurationEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventCmsSweeping;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public final class GcEventCmsSweepingImpl
extends GcDurationEventBaseImpl
implements GcEventCmsSweeping {
    private final boolean isConcurrent;
    private final long bytesFreedInOld;
    private final long bytesFreedInPerm;
    private final long bytesPromotedToOld;
    private final long bytesAllocatedInOld;
    private final long bytesAllocatedInPerm;
    private final long largestContiguousBlockInOld;
    private final long nrOfNonCoalesableBlocksInOld;
    private final long sizeOfNonCoalesableBlocksInOld;
    private final long nrOfNonCoalesableBlocksInPerm;
    private final long sizeOfNonCoalesableBlocksInPerm;

    public GcEventCmsSweepingImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.readDurationsAndPageFaults(reader, mapInfo, statistic);
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        boolean exact = statistic.isExact();
        this.isConcurrent = reader.readBoolean();
        this.bytesFreedInOld = reader.readInt64Percentage(statistic.getMaxOldGenSize(), exact);
        this.bytesFreedInPerm = this.ver() < 1 ? reader.readInt64Percentage(history.getReservedPermGenSize(), exact) : 0L;
        long bytesPromotedToOldMax = mapInfo.getSession().getSystemInfo().use2TimesMaxOldGenSizeAsMaximumForBytesPromotedDuringCmsCycle() ? statistic.getMaxOldGenSize() << 1 : statistic.getMaxOldGenSize();
        this.bytesPromotedToOld = reader.readInt64Percentage(bytesPromotedToOldMax, exact);
        this.bytesAllocatedInOld = reader.readInt64Percentage(statistic.getMaxOldGenSize(), exact);
        this.bytesAllocatedInPerm = this.ver() < 1 ? reader.readInt64Percentage(history.getReservedPermGenSize(), exact) : 0L;
        this.largestContiguousBlockInOld = reader.readInt64Percentage(statistic.getMaxOldGenSize(), exact);
        this.nrOfNonCoalesableBlocksInOld = reader.readCompressedInt32();
        this.sizeOfNonCoalesableBlocksInOld = reader.readInt64Percentage(statistic.getMaxOldGenSize(), exact);
        this.nrOfNonCoalesableBlocksInPerm = this.ver() < 1 ? (long)reader.readCompressedInt32() : 0L;
        this.sizeOfNonCoalesableBlocksInPerm = this.ver() < 1 ? reader.readInt64Percentage(history.getReservedPermGenSize(), exact) : 0L;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.formatln("Sweeping was concurrent                 : %s", this.isConcurrent ? "yes" : "no");
        stream.formatln("Freed in old gen by this GC             : %*B", this.bytesFreedInOld);
        if (this.ver() < 1) {
            stream.formatln("Freed in perm gen by this GC            : %*B", this.bytesFreedInPerm);
        }
        stream.formatln("Concurrently promoted to old gen        : %*B", this.bytesPromotedToOld);
        stream.formatln("Concurrently allocated in old gen       : %*B", this.bytesAllocatedInOld);
        if (this.ver() < 1) {
            stream.formatln("Concurrently allocated in perm gen      : %*B", this.bytesAllocatedInPerm);
        }
        stream.formatln("Largest contiguous block in old gen     : %*B", this.largestContiguousBlockInOld);
        stream.formatln("Non-coalescable blocks in old gen       : %d", this.nrOfNonCoalesableBlocksInOld);
        stream.formatln("Non-coalescable bytes in old gen        : %*B", this.sizeOfNonCoalesableBlocksInOld);
        if (this.ver() < 1) {
            stream.formatln("Non-coalescable blocks in perm gen      : %d", this.nrOfNonCoalesableBlocksInPerm);
            stream.formatln("Non-coalescable bytes in perm gen       : %*B", this.sizeOfNonCoalesableBlocksInPerm);
        }
    }

    @Override
    public long getBytesAllocatedInOld() {
        return this.bytesAllocatedInOld;
    }

    @Override
    public long getBytesAllocatedInPerm() {
        return this.bytesAllocatedInPerm;
    }

    @Override
    public long getBytesFreedInOld() {
        return this.bytesFreedInOld;
    }

    @Override
    public long getBytesFreedInPerm() {
        return this.bytesFreedInPerm;
    }

    @Override
    public long getBytesPromotedToOld() {
        return this.bytesPromotedToOld;
    }

    @Override
    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.CMS_SWEEPING;
    }

    @Override
    public long getLargestContiguousBlockInOld() {
        return this.largestContiguousBlockInOld;
    }

    @Override
    public long getNrOfNonCoalesableBlocksInOld() {
        return this.nrOfNonCoalesableBlocksInOld;
    }

    @Override
    public long getNrOfNonCoalesableBlocksInPerm() {
        return this.nrOfNonCoalesableBlocksInPerm;
    }

    @Override
    public long getSizeOfNonCoalesableBlocksInOld() {
        return this.sizeOfNonCoalesableBlocksInOld;
    }

    @Override
    public long getSizeOfNonCoalesableBlocksInPerm() {
        return this.sizeOfNonCoalesableBlocksInPerm;
    }
}

