/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GcDurationEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventG1BitmapClearing;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public final class GcEventG1BitmapClearingImpl
extends GcDurationEventBaseImpl
implements GcEventG1BitmapClearing {
    private final long clearedBitmapBytes;
    private final int yieldCount;

    public GcEventG1BitmapClearingImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.readDurationsAndPageFaults(reader, mapInfo, statistic);
        boolean exact = statistic.isExact();
        this.clearedBitmapBytes = reader.readInt64Percentage(statistic.getMaxOldGenSize(), exact);
        this.yieldCount = reader.readCompressedInt32();
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.println("Bytes cleared in the marking bitmap     : " + this.clearedBitmapBytes);
        stream.println("Number of yields                        : " + this.yieldCount);
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.G1_BITMAP_CLEARING;
    }

    @Override
    public long getClearedBitmapBytes() {
        return this.clearedBitmapBytes;
    }

    @Override
    public int getYieldCount() {
        return this.yieldCount;
    }

    @Override
    public boolean isConcurrent() {
        return true;
    }
}

