/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GcDurationEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventG1ConcurrentCleanup;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public final class GcEventG1ConcurrentCleanupImpl
extends GcDurationEventBaseImpl
implements GcEventG1ConcurrentCleanup {
    private final int regionsToBeCleared;
    private final long freedBytesInNonPerm;

    public GcEventG1ConcurrentCleanupImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.readDurationsAndPageFaults(reader, mapInfo, statistic);
        boolean exact = statistic.isExact();
        this.regionsToBeCleared = reader.readCompressedInt32();
        this.freedBytesInNonPerm = reader.readInt64Percentage(statistic.getMaxOldGenSize(), exact);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.println("Number of heap regions to be cleaned    : " + this.regionsToBeCleared);
        stream.formatln("Freed in Java heap by this GC           : %*B", this.freedBytesInNonPerm);
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.G1_CONCURRENT_CLEANUP;
    }

    @Override
    public int getRegionsToBeCleanedCount() {
        return this.regionsToBeCleared;
    }

    @Override
    public long getBytesFreedInNonPerm() {
        return this.freedBytesInNonPerm;
    }

    @Override
    public boolean isConcurrent() {
        return true;
    }
}

