/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GcDurationEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventG1Counting;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public final class GcEventG1CountingImpl
extends GcDurationEventBaseImpl
implements GcEventG1Counting {
    private final int iterations;

    public GcEventG1CountingImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.readDurationsAndPageFaults(reader, mapInfo, statistic);
        this.iterations = reader.readCompressedInt32();
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.println("Number of heap iterations               : " + this.iterations);
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.G1_COUNTING;
    }

    @Override
    public int getNrOfIterations() {
        return this.iterations;
    }

    @Override
    public boolean isConcurrent() {
        return true;
    }
}

