/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GcDurationEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventG1EmptyRegionsReclaim;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public final class GcEventG1EmptyRegionsReclaimImpl
extends GcDurationEventBaseImpl
implements GcEventG1EmptyRegionsReclaim {
    private final boolean isParallel;
    private final int nrOfThreads;
    private final long bytesInNonPerm;
    private final long liveBytesInNonPerm;
    private final int garbageRegionCount;
    private final long garbageRegionBytes;
    private double[] systemLoadAverage;
    private double[] virtualCpuUtilization;

    public GcEventG1EmptyRegionsReclaimImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.readDurationsAndPageFaults(reader, mapInfo, statistic);
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        boolean exact = statistic.isExact();
        this.nrOfThreads = reader.readCompressedInt32();
        boolean[] bools = reader.readBooleanArray();
        this.isParallel = bools[0];
        this.bytesInNonPerm = reader.readInt64Percentage(statistic.getMaxOldGenSize(), exact);
        this.liveBytesInNonPerm = reader.readInt64Percentage(statistic.getMaxOldGenSize(), exact);
        this.garbageRegionCount = reader.readCompressedInt32();
        this.garbageRegionBytes = reader.readInt64Percentage(statistic.getMaxOldGenSize(), exact);
        this.systemLoadAverage = history.readSystemLoadAverage(reader);
        this.virtualCpuUtilization = history.readSystemLoadAverage(reader);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.println("Empty regions reclaim was parallel      : " + (this.isParallel ? "yes" : "no"));
        stream.println("Number of parallel threads              : " + this.nrOfThreads);
        stream.formatln("Used in Java heap before event          : %*B", this.bytesInNonPerm);
        stream.formatln("Live in Java heap before event          : %*B", this.liveBytesInNonPerm);
        stream.formatln("Garbage in Java heap before event       : %*B", this.bytesInNonPerm - this.liveBytesInNonPerm);
        stream.println("Number of garbage only heap regions     : " + this.garbageRegionCount);
        stream.formatln("Bytes reclaimed of garbage regions      : %*B", this.garbageRegionBytes);
        stream.formatln("System load average                     : %.2f, %.2f, %.2f", this.systemLoadAverage[0], this.systemLoadAverage[1], this.systemLoadAverage[2]);
        stream.formatln("Host CPU utilization (virtualized)      : %.2f, %.2f, %.2f", this.virtualCpuUtilization[0], this.virtualCpuUtilization[1], this.virtualCpuUtilization[2]);
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.G1_EMPTY_REGIONS_RECLAIM;
    }

    @Override
    public boolean isParallel() {
        return this.isParallel;
    }

    @Override
    public int getNrOfGcThreads() {
        return this.nrOfThreads;
    }

    @Override
    public long getBytesInNonPermBefore() {
        return this.bytesInNonPerm;
    }

    @Override
    public long getLiveBytesInNonPerm() {
        return this.liveBytesInNonPerm;
    }

    @Override
    public int getGarbageRegionCount() {
        return this.garbageRegionCount;
    }

    @Override
    public long getBytesInGarbageRegions() {
        return this.garbageRegionBytes;
    }

    @Override
    public double[] getSystemLoadAverage() {
        return (double[])this.systemLoadAverage.clone();
    }

    @Override
    public double[] getVirtualCpuUtilization() {
        return (double[])this.virtualCpuUtilization.clone();
    }

    @Override
    public boolean isConcurrent() {
        return false;
    }
}

