/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GcDurationEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventG1FinalMarking;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public final class GcEventG1FinalMarkingImpl
extends GcDurationEventBaseImpl
implements GcEventG1FinalMarking {
    private final int nrOfThreads;
    private final boolean isRemarkingParallel;
    private final boolean isReferenceProcessingParallel;
    private final boolean hasMarkingStackOverflowOccurred;
    private final long successfulSteals;
    private final long failedSteals;
    private double[] systemLoadAverage;
    private double[] virtualCpuUtilization;
    private final long bytesScanned;
    private final long objectReferencesReached;
    private final long remarkingDuration;
    private final long remarkingCpuTime;
    private final long symbolUnloadingDuration;
    private final long symbolUnloadingCpuTime;
    private final long referenceHandlingDuration;
    private final long referenceHandlingCpuTime;
    private final long referenceEqueueingDuration;
    private final long referenceEqueueingCpuTime;

    public GcEventG1FinalMarkingImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.readDurationsAndPageFaults(reader, mapInfo, statistic);
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        boolean exact = statistic.isExact();
        this.nrOfThreads = this.ver() < 1 ? history.getNumberOfGCThreads() : reader.readCompressedInt32();
        boolean[] bools = reader.readBooleanArray();
        this.isRemarkingParallel = bools[0];
        this.hasMarkingStackOverflowOccurred = bools[1];
        this.successfulSteals = reader.readCompressedInt32();
        this.failedSteals = reader.readCompressedInt32();
        this.systemLoadAverage = history.readSystemLoadAverage(reader);
        this.virtualCpuUtilization = history.readSystemLoadAverage(reader);
        if (reader.hasNext()) {
            this.isReferenceProcessingParallel = bools[2];
            this.bytesScanned = reader.readCompressedInt64();
            this.objectReferencesReached = reader.readCompressedInt64();
            this.remarkingDuration = reader.readScaledInt32(1000L, exact);
            this.remarkingCpuTime = reader.readScaledInt32(1000L, exact);
            this.symbolUnloadingDuration = reader.readScaledInt32(1000L, exact);
            this.symbolUnloadingCpuTime = reader.readScaledInt32(1000L, exact);
            this.referenceHandlingDuration = reader.readScaledInt32(1000L, exact);
            this.referenceHandlingCpuTime = reader.readScaledInt32(1000L, exact);
            this.referenceEqueueingDuration = this.ver() < 3 ? reader.readScaledInt32(1000L, exact) : 0L;
            this.referenceEqueueingCpuTime = this.ver() < 3 ? reader.readScaledInt32(1000L, exact) : 0L;
        } else {
            this.isReferenceProcessingParallel = false;
            this.bytesScanned = 0L;
            this.objectReferencesReached = 0L;
            this.remarkingDuration = 0L;
            this.remarkingCpuTime = 0L;
            this.symbolUnloadingDuration = 0L;
            this.symbolUnloadingCpuTime = 0L;
            this.referenceHandlingDuration = 0L;
            this.referenceHandlingCpuTime = 0L;
            this.referenceEqueueingDuration = 0L;
            this.referenceEqueueingCpuTime = 0L;
        }
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.println("Remarking was parallel                  : " + (this.isRemarkingParallel ? "yes" : "no"));
        stream.println("Number of parallel threads              : " + this.nrOfThreads);
        stream.formatln("Number of bytes scanned                 :%*B", this.bytesScanned);
        stream.println("Number of object references reached     : " + this.objectReferencesReached);
        stream.println("Marking stack overflow occurred         : " + (this.hasMarkingStackOverflowOccurred ? "yes" : "no"));
        stream.println("Reference processing was parallel       : " + (this.isReferenceProcessingParallel ? "yes" : "no"));
        stream.println("Number of successful steal operations   : " + this.successfulSteals);
        stream.println("Number of failed steal operations       : " + this.failedSteals);
        stream.formatln("Remarking duration                      : %.2f ms", (double)this.remarkingDuration / 1000.0);
        stream.formatln("Remarking CPU time                      : %.2f ms", (double)this.remarkingCpuTime / 1000.0);
        stream.formatln("Symbol unloading duration               : %.2f ms", (double)this.symbolUnloadingDuration / 1000.0);
        stream.formatln("Symbol unloading CPU time               : %.2f ms", (double)this.symbolUnloadingCpuTime / 1000.0);
        stream.formatln("Reference processing duration           : %.2f ms", (double)this.referenceHandlingDuration / 1000.0);
        stream.formatln("Reference processing CPU time           : %.2f ms", (double)this.referenceHandlingCpuTime / 1000.0);
        if (this.ver() < 3) {
            stream.formatln("Reference enqueueing duration           : %.2f ms", (double)this.referenceEqueueingDuration / 1000.0);
            stream.formatln("Reference enqueueing CPU time           : %.2f ms", (double)this.referenceEqueueingCpuTime / 1000.0);
        }
        stream.formatln("System load average                     : %.2f, %.2f, %.2f", this.systemLoadAverage[0], this.systemLoadAverage[1], this.systemLoadAverage[2]);
        stream.formatln("Host CPU utilization (virtualized)      : %.2f, %.2f, %.2f", this.virtualCpuUtilization[0], this.virtualCpuUtilization[1], this.virtualCpuUtilization[2]);
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.G1_FINAL_MARKING;
    }

    @Override
    public int getNrOfThreads() {
        return this.nrOfThreads;
    }

    @Override
    public boolean isRemarkingParallel() {
        return this.isRemarkingParallel;
    }

    @Override
    public boolean hasMarkingStackOverflowOccurred() {
        return this.hasMarkingStackOverflowOccurred;
    }

    @Override
    public long getSuccessfulSteals() {
        return this.successfulSteals;
    }

    @Override
    public long getFailedSteals() {
        return this.failedSteals;
    }

    @Override
    public double[] getSystemLoadAverage() {
        return (double[])this.systemLoadAverage.clone();
    }

    @Override
    public double[] getVirtualCpuUtilization() {
        return (double[])this.virtualCpuUtilization.clone();
    }

    @Override
    public boolean isReferenceProcessingParallel() {
        return this.isReferenceProcessingParallel;
    }

    @Override
    public long getNrOfBytesScanned() {
        return this.bytesScanned;
    }

    @Override
    public long getNrOfObjectReferencesReached() {
        return this.objectReferencesReached;
    }

    @Override
    public long getRemarkingDuration() {
        return this.remarkingDuration;
    }

    @Override
    public long getRemarkingCpuTime() {
        return this.remarkingCpuTime;
    }

    @Override
    public long getSymbolUnloadingDuration() {
        return this.symbolUnloadingDuration;
    }

    @Override
    public long getSymbolUnloadingCpuTime() {
        return this.symbolUnloadingCpuTime;
    }

    @Override
    public long getReferenceHandlingDuration() {
        return this.referenceHandlingDuration;
    }

    @Override
    public long getReferenceHandlingCpuTime() {
        return this.referenceHandlingCpuTime;
    }

    @Override
    public long getReferenceEqueueingDuration() {
        return this.referenceEqueueingDuration;
    }

    @Override
    public long getReferenceEqueueingCpuTime() {
        return this.referenceEqueueingCpuTime;
    }

    @Override
    public boolean isConcurrent() {
        return false;
    }
}

