/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GcEventGenerationalImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventG1IncrementalGc;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.memory.event.GcG1OldRegionCSetSelTermReason;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public class GcEventG1IncrementalGcImpl
extends GcEventGenerationalImpl
implements GcEventG1IncrementalGc {
    private final boolean promotionFailed;
    private final int nrOfThreads;
    private final int pauseTimeTargetMs;
    private final int rsetUpdatingPauseTimePercent;
    private final long successfulSteals;
    private final long failedSteals;
    private final long failedStealsWithYield;
    private final int[] ageCounts;
    private final int[] ageSizes;
    private final long youngPlabSize;
    private final long oldPlabSize;
    private final boolean initialMarking;
    private final long concurrentMarkingRootScanWaitDuration;
    private final long parallelRootScanningDuration;
    private final long parallelSnapshotAtTheBeginningFilteringDuration;
    private final long parallelRememberedSetUpdatingDuration;
    private final int buffersProcessedDuringParallelRememberedSetUpdating;
    private final long parallelRememberedSetScanningDuration;
    private final long parallelObjectCopyingDuration;
    private final long cardTableClearingDuration;
    private final long collectionSetChoosingDuration;
    private final long collectionSetFreeingDuration;
    private final long referenceHandlingDuration;
    private final long referenceEnqueueingDuration;
    private final long pendingCards;
    private final long predictedBaseTime;
    private final long edenRegionLength;
    private final long survivorRegionLength;
    private final long predictedYoungTime;
    private final GcG1OldRegionCSetSelTermReason oldRegionCSetSelTermReason;
    private final long oldRegionLengthMin;
    private final long oldRegionLengthMax;
    private final long expensiveRegionLength;
    private final long oldRegionLength;
    private final long predictedPauseTime;
    private final long nrOfHumongousReclaimed;
    private final boolean hasOnlyYoungRegions;
    private final long timeRegisterHumongousEagerReclaim;
    private final long nrHumongousReclaimCandidates;
    private final long humongousEagerReclaimTime;
    private final long recordedRedirtyClearingDuration;
    private final long cumulativeTerminationDuration;

    private GcG1OldRegionCSetSelTermReason getGcG1OldRegionCSetSelTermReason(int value) {
        switch (value) {
            case 0: {
                return GcG1OldRegionCSetSelTermReason.NO_MIXED_COLLECTION;
            }
            case 1: {
                return GcG1OldRegionCSetSelTermReason.MAX_LEN;
            }
            case 2: {
                return GcG1OldRegionCSetSelTermReason.RECLAIMABLE_BELOW_THRESHOLD;
            }
            case 3: {
                return GcG1OldRegionCSetSelTermReason.PREDICTED_TIME_TOO_LONG;
            }
            case 4: {
                return GcG1OldRegionCSetSelTermReason.MIN_REACHED;
            }
            case 5: {
                return GcG1OldRegionCSetSelTermReason.NO_CANDIDATE_AVBL;
            }
        }
        throw new IllegalArgumentException("Unknown reason for CSet selection termination " + value);
    }

    public GcEventG1IncrementalGcImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.readDurationsAndPageFaults(reader, mapInfo, statistic);
        this.readGenerationsAndLoad(reader, mapInfo, statistic);
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        boolean exact = statistic.isExact();
        boolean[] bools = reader.readBooleanArray();
        this.promotionFailed = bools[0];
        this.initialMarking = bools[1];
        this.hasOnlyYoungRegions = bools[2];
        this.nrOfThreads = this.ver() < 1 ? history.getNumberOfGCThreads() : reader.readCompressedInt32();
        this.pauseTimeTargetMs = history.getPauseTimeTargetMs();
        this.rsetUpdatingPauseTimePercent = history.getRsetUpdatingPauseTimePercent();
        this.youngPlabSize = reader.readScaledInt32(1024L, exact);
        this.oldPlabSize = reader.readScaledInt32(1024L, exact);
        this.successfulSteals = reader.readCompressedInt32();
        this.failedSteals = reader.readCompressedInt32();
        this.failedStealsWithYield = reader.readCompressedInt32();
        this.ageCounts = new int[32];
        this.ageSizes = new int[32];
        long youngObjectCount = reader.readInt64Percentage(statistic.getMaxYoungGenSize() / (long)history.getMinObjectSize(), exact);
        for (int i = 0; i <= history.getMaxObjectAge(); ++i) {
            this.ageCounts[i] = (int)reader.readInt64Percentage(youngObjectCount, exact);
        }
        long youngObjectSize = reader.readInt64Percentage(statistic.getMaxYoungGenSize(), exact);
        for (int i = 0; i <= history.getMaxObjectAge(); ++i) {
            this.ageSizes[i] = (int)reader.readInt64Percentage(youngObjectSize, exact);
        }
        this.readVirtualizedLoad(reader, mapInfo, statistic);
        if (reader.hasNext()) {
            this.concurrentMarkingRootScanWaitDuration = reader.readScaledInt32(1000L, exact);
            this.parallelRootScanningDuration = reader.readScaledInt32(1000L, exact);
            this.parallelSnapshotAtTheBeginningFilteringDuration = reader.readScaledInt32(1000L, exact);
            this.parallelRememberedSetUpdatingDuration = reader.readScaledInt32(1000L, exact);
            this.buffersProcessedDuringParallelRememberedSetUpdating = reader.readCompressedInt32();
            this.parallelRememberedSetScanningDuration = reader.readScaledInt32(1000L, exact);
            this.parallelObjectCopyingDuration = reader.readScaledInt32(1000L, exact);
            this.cardTableClearingDuration = reader.readScaledInt32(1000L, exact);
            this.collectionSetChoosingDuration = reader.readScaledInt32(1000L, exact);
            this.collectionSetFreeingDuration = reader.readScaledInt32(1000L, exact);
            this.referenceHandlingDuration = reader.readScaledInt32(1000L, exact);
            long l = this.referenceEnqueueingDuration = this.ver() < 3 ? reader.readScaledInt32(1000L, exact) : 0L;
            if (reader.hasNext()) {
                this.pendingCards = reader.readCompressedInt32();
                this.predictedBaseTime = reader.readScaledInt32(1000L, exact);
                this.edenRegionLength = reader.readCompressedInt32();
                this.survivorRegionLength = reader.readCompressedInt32();
                this.predictedYoungTime = reader.readScaledInt32(1000L, exact);
                this.oldRegionCSetSelTermReason = this.getGcG1OldRegionCSetSelTermReason(reader.readInt8());
                this.oldRegionLengthMin = reader.readCompressedInt32();
                this.oldRegionLengthMax = reader.readCompressedInt32();
                this.expensiveRegionLength = reader.readCompressedInt32();
                this.oldRegionLength = reader.readCompressedInt32();
                this.predictedPauseTime = reader.readScaledInt32(1000L, exact);
                this.nrOfHumongousReclaimed = reader.readCompressedInt32();
                if (reader.hasNext()) {
                    this.timeRegisterHumongousEagerReclaim = reader.readScaledInt32(1000L, exact);
                    this.nrHumongousReclaimCandidates = reader.readCompressedInt32();
                    this.humongousEagerReclaimTime = reader.readScaledInt32(1000L, exact);
                    this.recordedRedirtyClearingDuration = reader.readScaledInt32(1000L, exact);
                    this.cumulativeTerminationDuration = reader.readScaledInt32(1000L, exact);
                } else {
                    this.timeRegisterHumongousEagerReclaim = 0L;
                    this.nrHumongousReclaimCandidates = 0L;
                    this.humongousEagerReclaimTime = 0L;
                    this.recordedRedirtyClearingDuration = 0L;
                    this.cumulativeTerminationDuration = 0L;
                }
            } else {
                this.pendingCards = 0L;
                this.predictedBaseTime = 0L;
                this.edenRegionLength = 0L;
                this.survivorRegionLength = 0L;
                this.predictedYoungTime = 0L;
                this.oldRegionCSetSelTermReason = this.getGcG1OldRegionCSetSelTermReason(0);
                this.oldRegionLengthMin = 0L;
                this.oldRegionLengthMax = 0L;
                this.expensiveRegionLength = 0L;
                this.oldRegionLength = 0L;
                this.predictedPauseTime = 0L;
                this.nrOfHumongousReclaimed = 0L;
                this.timeRegisterHumongousEagerReclaim = 0L;
                this.nrHumongousReclaimCandidates = 0L;
                this.humongousEagerReclaimTime = 0L;
                this.recordedRedirtyClearingDuration = 0L;
                this.cumulativeTerminationDuration = 0L;
            }
        } else {
            this.concurrentMarkingRootScanWaitDuration = 0L;
            this.parallelRootScanningDuration = 0L;
            this.parallelSnapshotAtTheBeginningFilteringDuration = 0L;
            this.parallelRememberedSetUpdatingDuration = 0L;
            this.buffersProcessedDuringParallelRememberedSetUpdating = 0;
            this.parallelRememberedSetScanningDuration = 0L;
            this.parallelObjectCopyingDuration = 0L;
            this.cardTableClearingDuration = 0L;
            this.collectionSetChoosingDuration = 0L;
            this.collectionSetFreeingDuration = 0L;
            this.referenceHandlingDuration = 0L;
            this.referenceEnqueueingDuration = 0L;
            this.pendingCards = 0L;
            this.predictedBaseTime = 0L;
            this.edenRegionLength = 0L;
            this.survivorRegionLength = 0L;
            this.predictedYoungTime = 0L;
            this.oldRegionCSetSelTermReason = this.getGcG1OldRegionCSetSelTermReason(0);
            this.oldRegionLengthMin = 0L;
            this.oldRegionLengthMax = 0L;
            this.expensiveRegionLength = 0L;
            this.oldRegionLength = 0L;
            this.predictedPauseTime = 0L;
            this.nrOfHumongousReclaimed = 0L;
            this.timeRegisterHumongousEagerReclaim = 0L;
            this.nrHumongousReclaimCandidates = 0L;
            this.humongousEagerReclaimTime = 0L;
            this.recordedRedirtyClearingDuration = 0L;
            this.cumulativeTerminationDuration = 0L;
        }
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.println("Number of parallel threads              : " + this.nrOfThreads);
        stream.println("Promotion failed                        : " + (this.promotionFailed ? "yes" : "no"));
        stream.println("Includes initial marking                : " + (this.initialMarking ? "yes" : "no"));
        stream.println("Included heap regions                   : " + (this.hasOnlyYoungRegions ? "young" : "young and old"));
        stream.println("Number of successful steal operations   : " + this.successfulSteals);
        stream.println("Number of failed steal operations       : " + this.failedSteals);
        stream.println("Number of failed steals and yields      : " + this.failedStealsWithYield);
        stream.formatln("Size of 'to' space PLAB (per thread)    : %*B", this.youngPlabSize);
        stream.formatln("Size of 'old' space PLAB (per thread)   : %*B", this.oldPlabSize);
        stream.formatln("Waited for conc mark root scanning      : %.2f ms", (double)this.concurrentMarkingRootScanWaitDuration / 1000.0);
        stream.formatln("Parallel root scanning duration         : %.2f ms", (double)this.parallelRootScanningDuration / 1000.0);
        stream.formatln("Parallel SATB filtering duration        : %.2f ms", (double)this.parallelSnapshotAtTheBeginningFilteringDuration / 1000.0);
        stream.formatln("Parallel remembered set updating        : %.2f ms", (double)this.parallelRememberedSetUpdatingDuration / 1000.0);
        stream.println("Nr of buffers processed during rs upd   : " + this.buffersProcessedDuringParallelRememberedSetUpdating);
        stream.formatln("Parallel remembered set scanning        : %.2f ms", (double)this.parallelRememberedSetScanningDuration / 1000.0);
        stream.formatln("Parallel object copying duration        : %.2f ms", (double)this.parallelObjectCopyingDuration / 1000.0);
        stream.formatln("Card table clearing duration            : %.2f ms", (double)this.cardTableClearingDuration / 1000.0);
        stream.formatln("Collection set choosing duration        : %.2f ms", (double)this.collectionSetChoosingDuration / 1000.0);
        stream.formatln("Collection set freeing duration         : %.2f ms", (double)this.collectionSetFreeingDuration / 1000.0);
        stream.formatln("Reference handling duration             : %.2f ms", (double)this.referenceHandlingDuration / 1000.0);
        if (this.ver() < 3) {
            stream.formatln("Reference enqueueing duration           : %.2f ms", (double)this.referenceEnqueueingDuration / 1000.0);
        }
        stream.formatln("Pending cards at start of CSet sel.     : " + this.pendingCards, new Object[0]);
        stream.formatln("Target pause time                       : %d.00 ms", this.pauseTimeTargetMs);
        stream.formatln("Target of pause used for RS update      : %d %%", this.rsetUpdatingPauseTimePercent);
        stream.formatln("Pred. base time at start of CSet sel.   : %.2f ms", (double)this.predictedBaseTime / 1000.0);
        stream.formatln("Nr. of eden regions in CSet             : " + this.edenRegionLength, new Object[0]);
        stream.formatln("Nr. of survivor regions in CSet         : " + this.survivorRegionLength, new Object[0]);
        stream.formatln("Predicted young region time             : %.2f ms", (double)this.predictedYoungTime / 1000.0);
        stream.formatln("Old CSet selection termination reason   : %s", this.oldRegionCSetSelTermReason.getShortDescription());
        stream.formatln("Min. number of old regions in CSet      : " + this.oldRegionLengthMin, new Object[0]);
        stream.formatln("Max. number of old regions in CSet      : " + this.oldRegionLengthMax, new Object[0]);
        stream.formatln("Number of expensive regions in CSet     : " + this.expensiveRegionLength, new Object[0]);
        stream.formatln("Number of old regions in CSet           : " + this.oldRegionLength, new Object[0]);
        stream.formatln("Predicted pause time                    : %.2f ms", (double)this.predictedPauseTime / 1000.0);
        stream.formatln("Number of reclaimed humongous objects   : %d", this.nrOfHumongousReclaimed);
        stream.formatln("Humongous register time for reclaim     : %.2f ms", (double)this.timeRegisterHumongousEagerReclaim / 1000.0);
        stream.formatln("Nr. humongous candidates for reclaim    : %d", this.nrHumongousReclaimCandidates);
        stream.formatln("Humongous eager reclaim time            : %.2f ms", (double)this.humongousEagerReclaimTime / 1000.0);
        stream.formatln("Redirty logged cards time               : %.2f ms", (double)this.recordedRedirtyClearingDuration / 1000.0);
        stream.formatln("Cumulative termination phase duration   : %.2f ms", (double)this.cumulativeTerminationDuration / 1000.0);
        for (int i = 0; i < 32; ++i) {
            stream.formatln("Objects of age %2d                       : %d, %*B", i, this.ageCounts[i], this.ageSizes[i]);
        }
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.G1_INCREMENTAL_GC;
    }

    @Override
    public boolean isPromotionFailed() {
        return this.promotionFailed;
    }

    @Override
    public int getNrOfThreads() {
        return this.nrOfThreads;
    }

    @Override
    public long getSuccessfulSteals() {
        return this.successfulSteals;
    }

    @Override
    public long getFailedSteals() {
        return this.failedSteals;
    }

    @Override
    public long getFailedStealsWithYield() {
        return this.failedStealsWithYield;
    }

    @Override
    public int[] getAgeCounts() {
        return (int[])this.ageCounts.clone();
    }

    @Override
    public int[] getAgeSizes() {
        return (int[])this.ageSizes.clone();
    }

    @Override
    public long getYoungPLABSize() {
        return this.youngPlabSize;
    }

    @Override
    public long getOldPLABSize() {
        return this.oldPlabSize;
    }

    @Override
    public boolean hasInitialMarking() {
        return this.initialMarking;
    }

    @Override
    public long getConcurrentMarkingRootScanWaitDuration() {
        return this.concurrentMarkingRootScanWaitDuration;
    }

    @Override
    public long getParallelRootScanningDuration() {
        return this.parallelRootScanningDuration;
    }

    @Override
    public long getParallelSnapshotAtTheBeginningFilteringDuration() {
        return this.parallelSnapshotAtTheBeginningFilteringDuration;
    }

    @Override
    public long getParallelRememberedSetUpdatingDuration() {
        return this.parallelRememberedSetUpdatingDuration;
    }

    @Override
    public int getBuffersProcessedDuringParallelRememberedSetUpdating() {
        return this.buffersProcessedDuringParallelRememberedSetUpdating;
    }

    @Override
    public long getParallelRememberedSetScanningDuration() {
        return this.parallelRememberedSetScanningDuration;
    }

    @Override
    public long getParallelObjectCopyingDuration() {
        return this.parallelObjectCopyingDuration;
    }

    @Override
    public long getCardTableClearingDuration() {
        return this.cardTableClearingDuration;
    }

    @Override
    public long getCollectionSetChoosingDuration() {
        return this.collectionSetChoosingDuration;
    }

    @Override
    public long getCollectionSetFreeingDuration() {
        return this.collectionSetFreeingDuration;
    }

    @Override
    public long getReferenceHandlingDuration() {
        return this.referenceHandlingDuration;
    }

    @Override
    public long getReferenceEnqueueingDuration() {
        return this.referenceEnqueueingDuration;
    }

    @Override
    public long getPendingCards() {
        return this.pendingCards;
    }

    @Override
    public long getPredictedBaseTime() {
        return this.predictedBaseTime;
    }

    @Override
    public long getEdenRegionLength() {
        return this.edenRegionLength;
    }

    @Override
    public long getSurvivorRegionLength() {
        return this.survivorRegionLength;
    }

    @Override
    public long getPredictedYoungTime() {
        return this.predictedYoungTime;
    }

    @Override
    public GcG1OldRegionCSetSelTermReason getOldRegionCSetSelTermReason() {
        return this.oldRegionCSetSelTermReason;
    }

    @Override
    public long getOldRegionLengthMin() {
        return this.oldRegionLengthMin;
    }

    @Override
    public long getOldRegionLengthMax() {
        return this.oldRegionLengthMax;
    }

    @Override
    public long getExpensiveRegionLength() {
        return this.expensiveRegionLength;
    }

    @Override
    public long getOldRegionLength() {
        return this.oldRegionLength;
    }

    @Override
    public long getPredictedPauseTime() {
        return this.predictedPauseTime;
    }

    @Override
    public long getNrOfHumongousReclaimed() {
        return this.nrOfHumongousReclaimed;
    }

    @Override
    public boolean hasOnlyYoungRegions() {
        return this.hasOnlyYoungRegions;
    }

    public long getTimeRegisterHumongousEagerReclaim() {
        return this.timeRegisterHumongousEagerReclaim;
    }

    public long getNrHumongousReclaimCandidates() {
        return this.nrHumongousReclaimCandidates;
    }

    public long getHumongousEagerReclaimTime() {
        return this.humongousEagerReclaimTime;
    }

    public long getRecordedRedirtyClearingDuration() {
        return this.recordedRedirtyClearingDuration;
    }

    public long getCumulativeTerminationDuration() {
        return this.cumulativeTerminationDuration;
    }
}

