/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GcDurationEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventG1InitialMarking;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public final class GcEventG1InitialMarkingImpl
extends GcDurationEventBaseImpl
implements GcEventG1InitialMarking {
    private final int nrOfThreads;
    private final boolean isParallel;
    private final boolean isPartOfPartialGc;
    private final long bytesInNonPerm;
    private final long committedBytesInNonPerm;
    private final double[] systemLoadAverage;
    private final double[] virtualCpuUtilization;

    public GcEventG1InitialMarkingImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.readDurationsAndPageFaults(reader, mapInfo, statistic);
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        boolean exact = statistic.isExact();
        int nrOfThreadsFromStream = -1;
        if (this.ver() >= 1) {
            nrOfThreadsFromStream = reader.readCompressedInt32();
        }
        boolean[] bools = reader.readBooleanArray();
        this.isParallel = bools[0];
        this.isPartOfPartialGc = bools[1];
        this.nrOfThreads = this.isParallel ? (this.ver() < 1 ? history.getNumberOfGCThreads() : nrOfThreadsFromStream) : 1;
        this.bytesInNonPerm = reader.readInt64Percentage(statistic.getMaxOldGenSize(), exact);
        this.committedBytesInNonPerm = reader.readInt64InvPercentage(statistic.getMaxOldGenSize(), exact);
        this.systemLoadAverage = history.readSystemLoadAverage(reader);
        this.virtualCpuUtilization = history.readSystemLoadAverage(reader);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.println("Initial marking was parallel            : " + (this.isParallel ? "yes" : "no"));
        stream.println("Initial marking was part of partial GC  : " + (this.isPartOfPartialGc ? "yes" : "no"));
        stream.formatln("Used in Java heap after event           : %*B", this.bytesInNonPerm);
        stream.formatln("Committed in Java heap after event      : %*B", this.committedBytesInNonPerm);
        stream.println("Number of parallel marking threads      : " + this.nrOfThreads);
        stream.formatln("System load average                     : %.2f, %.2f, %.2f", this.systemLoadAverage[0], this.systemLoadAverage[1], this.systemLoadAverage[2]);
        stream.formatln("Host CPU utilization (virtualized)      : %.2f, %.2f, %.2f", this.virtualCpuUtilization[0], this.virtualCpuUtilization[1], this.virtualCpuUtilization[2]);
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.G1_INITIAL_MARKING;
    }

    @Override
    public int getNrOfThreads() {
        return this.nrOfThreads;
    }

    @Override
    public boolean isParallel() {
        return this.isParallel;
    }

    @Override
    public boolean isPartOfPartialGc() {
        return this.isPartOfPartialGc;
    }

    @Override
    public long getBytesInNonPermAfter() {
        return this.bytesInNonPerm;
    }

    @Override
    public long getCommittedBytesInNonPermAfter() {
        return this.committedBytesInNonPerm;
    }

    @Override
    public double[] getSystemLoadAverage() {
        return (double[])this.systemLoadAverage.clone();
    }

    @Override
    public double[] getVirtualCpuUtilization() {
        return (double[])this.virtualCpuUtilization.clone();
    }

    @Override
    public boolean isConcurrent() {
        return false;
    }
}

