/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GcEventGenerationalImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventG1MarkSweepGc;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public final class GcEventG1MarkSweepGcImpl
extends GcEventGenerationalImpl
implements GcEventG1MarkSweepGc {
    private final long allowedNonPermDeadSpace;
    private final long usedNonPermDeadSpace;
    private final long allowedPermDeadSpace;
    private final long usedPermDeadSpace;
    private final boolean clearSoftRefs;
    private final long nrOfUnloadedClasses;
    private final long phase1Duration;
    private final long phase1CpuTime;
    private final long phase2Duration;
    private final long phase2CpuTime;
    private final long phase3Duration;
    private final long phase3CpuTime;
    private final long phase4Duration;
    private final long phase4CpuTime;

    public GcEventG1MarkSweepGcImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.readDurationsAndPageFaults(reader, mapInfo, statistic);
        this.readGenerationsAndLoad(reader, mapInfo, statistic);
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        boolean exact = statistic.isExact();
        byte logBytesPerWord = mapInfo.getSession().getSystemInfo().getLogBytesPerWord();
        this.allowedNonPermDeadSpace = reader.readInt64Percentage(history.getReservedJavaHeapSize(), exact) << logBytesPerWord;
        this.usedNonPermDeadSpace = reader.readInt64Percentage(history.getReservedJavaHeapSize(), exact) << logBytesPerWord;
        this.allowedPermDeadSpace = this.ver() < 1 ? reader.readInt64Percentage(history.getReservedPermGenSize(), exact) : 0L;
        this.usedPermDeadSpace = this.ver() < 1 ? reader.readInt64Percentage(history.getReservedPermGenSize(), exact) : 0L;
        this.nrOfUnloadedClasses = this.ver() < 1 ? reader.readCompressedInt64() : 0L;
        this.clearSoftRefs = reader.readBoolean();
        this.phase1Duration = reader.readScaledInt32(1000L, exact);
        this.phase1CpuTime = reader.readScaledInt32(1000L, exact);
        this.phase2Duration = reader.readScaledInt32(1000L, exact);
        this.phase2CpuTime = reader.readScaledInt32(1000L, exact);
        this.phase3Duration = reader.readScaledInt32(1000L, exact);
        this.phase3CpuTime = reader.readScaledInt32(1000L, exact);
        this.phase4Duration = reader.readScaledInt32(1000L, exact);
        this.phase4CpuTime = reader.readScaledInt32(1000L, exact);
        this.readVirtualizedLoad(reader, mapInfo, statistic);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        if (this.ver() < 1) {
            stream.println("Nr. of unloaded classes                 : " + this.nrOfUnloadedClasses);
        }
        stream.println("Forced clearing of soft references      : " + (this.clearSoftRefs ? "yes" : "no"));
        stream.formatln("Allowed dead space in non-perm gens     : %*B", this.allowedNonPermDeadSpace);
        stream.formatln("Used dead space in non-perm gens        : %*B", this.usedNonPermDeadSpace);
        if (this.ver() < 1) {
            stream.formatln("Allowed dead space in perm gen          : %*B", this.allowedPermDeadSpace);
            stream.formatln("Used dead space in perm gen             : %*B", this.usedPermDeadSpace);
        }
        stream.formatln("Phase 1 (marking) duration              : %.2f ms", (double)this.phase1Duration / 1000.0);
        stream.formatln("Phase 1 (marking) CPU time              : %.2f ms", (double)this.phase1CpuTime / 1000.0);
        stream.formatln("Phase 2 (address calculation) duration  : %.2f ms", (double)this.phase2Duration / 1000.0);
        stream.formatln("Phase 2 (address calculation) CPU time  : %.2f ms", (double)this.phase2CpuTime / 1000.0);
        stream.formatln("Phase 3 (updating pointers) duration    : %.2f ms", (double)this.phase3Duration / 1000.0);
        stream.formatln("Phase 3 (updating pointers) CPU time    : %.2f ms", (double)this.phase3CpuTime / 1000.0);
        stream.formatln("Phase 4 (moving objects) duration       : %.2f ms", (double)this.phase4Duration / 1000.0);
        stream.formatln("Phase 4 (moving objects) CPU time       : %.2f ms", (double)this.phase4CpuTime / 1000.0);
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.G1_MARK_SWEEP_GC;
    }

    @Override
    public long getAllowedNonPermDeadSpace() {
        return this.allowedNonPermDeadSpace;
    }

    @Override
    public long getAllowedPermDeadSpace() {
        return this.allowedPermDeadSpace;
    }

    @Override
    public boolean isClearSoftRefs() {
        return this.clearSoftRefs;
    }

    @Override
    public long getNrOfUnloadedClasses() {
        return this.nrOfUnloadedClasses;
    }

    @Override
    public long getUsedNonPermDeadSpace() {
        return this.usedNonPermDeadSpace;
    }

    @Override
    public long getUsedPermDeadSpace() {
        return this.usedPermDeadSpace;
    }

    @Override
    public long getPhase1Duration() {
        return this.phase1Duration;
    }

    @Override
    public long getPhase1CpuTime() {
        return this.phase1CpuTime;
    }

    @Override
    public long getPhase2Duration() {
        return this.phase2Duration;
    }

    @Override
    public long getPhase2CpuTime() {
        return this.phase2CpuTime;
    }

    @Override
    public long getPhase3Duration() {
        return this.phase3Duration;
    }

    @Override
    public long getPhase3CpuTime() {
        return this.phase3CpuTime;
    }

    @Override
    public long getPhase4Duration() {
        return this.phase4Duration;
    }

    @Override
    public long getPhase4CpuTime() {
        return this.phase4CpuTime;
    }
}

