/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GcDurationEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventG1Marking;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public final class GcEventG1MarkingImpl
extends GcDurationEventBaseImpl
implements GcEventG1Marking {
    private final int nrOfThreads;
    private final boolean isParallel;
    private final long successfulSteals;
    private final long failedSteals;

    public GcEventG1MarkingImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.readDurationsAndPageFaults(reader, mapInfo, statistic);
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        boolean[] bools = reader.readBooleanArray();
        this.isParallel = bools[0];
        this.nrOfThreads = this.ver() < 1 ? history.getNumberOfConcurrentGCThreads() : reader.readCompressedInt32();
        this.successfulSteals = reader.readCompressedInt32();
        this.failedSteals = reader.readCompressedInt32();
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.println("Marking was parallel                    : " + (this.isParallel ? "yes" : "no"));
        stream.println("Number of parallel marking threads      : " + this.nrOfThreads);
        stream.println("Number of successful steal operations   : " + this.successfulSteals);
        stream.println("Number of failed steal operations       : " + this.failedSteals);
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.G1_MARKING;
    }

    @Override
    public int getNrOfThreads() {
        return this.nrOfThreads;
    }

    @Override
    public boolean isParallel() {
        return this.isParallel;
    }

    @Override
    public long getSuccessfulSteals() {
        return this.successfulSteals;
    }

    @Override
    public long getFailedSteals() {
        return this.failedSteals;
    }

    @Override
    public boolean isConcurrent() {
        return true;
    }
}

