/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GcEventGenerationalImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventG1ParallelFullGc;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public final class GcEventG1ParallelFullGcImpl
extends GcEventGenerationalImpl
implements GcEventG1ParallelFullGc {
    private final boolean clearSoftRefs;
    private final int nrOfThreads;
    private final long phase1Duration;
    private final long phase1CpuTime;
    private final long phase2Duration;
    private final long phase2CpuTime;
    private final long phase3Duration;
    private final long phase3CpuTime;
    private final long phase4Duration;
    private final long phase4CpuTime;

    public GcEventG1ParallelFullGcImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.readDurationsAndPageFaults(reader, mapInfo, statistic);
        this.readGenerationsAndLoad(reader, mapInfo, statistic);
        boolean exact = statistic.isExact();
        this.clearSoftRefs = reader.readBoolean();
        this.nrOfThreads = reader.readCompressedInt32();
        this.phase1Duration = reader.readScaledInt32(1000L, exact);
        this.phase1CpuTime = reader.readScaledInt32(1000L, exact);
        this.phase2Duration = reader.readScaledInt32(1000L, exact);
        this.phase2CpuTime = reader.readScaledInt32(1000L, exact);
        this.phase3Duration = reader.readScaledInt32(1000L, exact);
        this.phase3CpuTime = reader.readScaledInt32(1000L, exact);
        this.phase4Duration = reader.readScaledInt32(1000L, exact);
        this.phase4CpuTime = reader.readScaledInt32(1000L, exact);
        this.readVirtualizedLoad(reader, mapInfo, statistic);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.println("Forced clearing of soft references      : " + (this.clearSoftRefs ? "yes" : "no"));
        stream.println("Number of parallel GC threads           : " + this.nrOfThreads);
        stream.formatln("Phase 1 (marking) duration              : %.2f ms", (double)this.phase1Duration / 1000.0);
        stream.formatln("Phase 1 (marking) CPU time              : %.2f ms", (double)this.phase1CpuTime / 1000.0);
        stream.formatln("Phase 2 (address calculation) duration  : %.2f ms", (double)this.phase2Duration / 1000.0);
        stream.formatln("Phase 2 (address calculation) CPU time  : %.2f ms", (double)this.phase2CpuTime / 1000.0);
        stream.formatln("Phase 3 (updating pointers) duration    : %.2f ms", (double)this.phase3Duration / 1000.0);
        stream.formatln("Phase 3 (updating pointers) CPU time    : %.2f ms", (double)this.phase3CpuTime / 1000.0);
        stream.formatln("Phase 4 (moving objects) duration       : %.2f ms", (double)this.phase4Duration / 1000.0);
        stream.formatln("Phase 4 (moving objects) CPU time       : %.2f ms", (double)this.phase4CpuTime / 1000.0);
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.G1_PARALLEL_FULL_GC;
    }

    @Override
    public boolean isClearSoftRefs() {
        return this.clearSoftRefs;
    }

    @Override
    public int getNrOfThreads() {
        return this.nrOfThreads;
    }

    @Override
    public long getPhase1Duration() {
        return this.phase1Duration;
    }

    @Override
    public long getPhase1CpuTime() {
        return this.phase1CpuTime;
    }

    @Override
    public long getPhase2Duration() {
        return this.phase2Duration;
    }

    @Override
    public long getPhase2CpuTime() {
        return this.phase2CpuTime;
    }

    @Override
    public long getPhase3Duration() {
        return this.phase3Duration;
    }

    @Override
    public long getPhase3CpuTime() {
        return this.phase3CpuTime;
    }

    @Override
    public long getPhase4Duration() {
        return this.phase4Duration;
    }

    @Override
    public long getPhase4CpuTime() {
        return this.phase4CpuTime;
    }
}

