/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GcDurationEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventG1RootScanning;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public final class GcEventG1RootScanningImpl
extends GcDurationEventBaseImpl
implements GcEventG1RootScanning {
    private final int nrOfThreads;
    private final boolean isParallel;
    private final int scannedRegions;

    public GcEventG1RootScanningImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.readDurationsAndPageFaults(reader, mapInfo, statistic);
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        boolean[] bools = reader.readBooleanArray();
        this.isParallel = bools[0];
        this.nrOfThreads = this.ver() < 1 ? history.getNumberOfConcurrentGCThreads() : reader.readCompressedInt32();
        this.scannedRegions = reader.readCompressedInt32();
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.println("Number of root regions scanned          : " + this.scannedRegions);
        stream.println("Root scanning was parallel              : " + (this.isParallel ? "yes" : "no"));
        stream.println("Number of parallel scanning threads     : " + this.nrOfThreads);
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.G1_ROOT_SCANNING;
    }

    @Override
    public int getNrOfThreads() {
        return this.nrOfThreads;
    }

    @Override
    public boolean isParallel() {
        return this.isParallel;
    }

    @Override
    public int getScannedRootRegions() {
        return this.scannedRegions;
    }

    @Override
    public boolean isConcurrent() {
        return true;
    }
}

