/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GcDurationEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventGenerational;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public abstract class GcEventGenerationalImpl
extends GcDurationEventBaseImpl
implements GcEventGenerational {
    private long bytesInEdenBefore;
    private long bytesInEdenAfter;
    private long bytesInFromBefore;
    private long bytesInFromAfter;
    private long bytesInToBefore;
    private long bytesInToAfter;
    private long bytesInOldBefore;
    private long bytesInOldAfter;
    private long bytesInPermBefore;
    private long bytesInPermAfter;
    private double[] systemLoadAverage;
    private double[] virtualCpuUtilization;

    protected GcEventGenerationalImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
    }

    private void printSpace(ProfilingPrintStream stream, String spaceName, long usedBefore, long usedAfter) {
        stream.formatln("%-40s: %*B", "Used in " + spaceName + " before event", usedBefore);
        stream.formatln("%-40s: %*B", "Used in " + spaceName + " after event", usedAfter);
        long freed = usedBefore - usedAfter;
        stream.formatln("%-40s: %*B", "Freed in " + spaceName, freed);
    }

    protected void readGenerationsAndLoad(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        boolean exact = statistic.isExact();
        this.bytesInEdenBefore = reader.readInt64InvPercentage(statistic.getMaxYoungGenSize(), exact);
        this.bytesInEdenAfter = reader.readInt64Percentage(statistic.getMaxYoungGenSize(), exact);
        this.bytesInFromBefore = reader.readInt64Percentage(statistic.getMaxYoungGenSize(), exact);
        this.bytesInFromAfter = reader.readInt64Percentage(statistic.getMaxYoungGenSize(), exact);
        this.bytesInToBefore = reader.readInt64Percentage(statistic.getMaxYoungGenSize(), exact);
        this.bytesInToAfter = reader.readInt64Percentage(statistic.getMaxYoungGenSize(), exact);
        this.bytesInOldBefore = reader.readInt64Percentage(statistic.getMaxOldGenSize(), exact);
        this.bytesInOldAfter = reader.readInt64Percentage(statistic.getMaxOldGenSize(), exact);
        this.bytesInPermBefore = this.ver() < 1 ? reader.readInt64Percentage(history.getReservedPermGenSize(), exact) : 0L;
        this.bytesInPermAfter = this.ver() < 1 ? reader.readInt64Percentage(history.getReservedPermGenSize(), exact) : 0L;
        this.systemLoadAverage = history.readSystemLoadAverage(reader);
    }

    protected void readVirtualizedLoad(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        this.virtualCpuUtilization = history.readSystemLoadAverage(reader);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        this.printSpace(stream, "eden", this.bytesInEdenBefore, this.bytesInEdenAfter);
        this.printSpace(stream, "'from' space", this.bytesInFromBefore, this.bytesInFromAfter);
        this.printSpace(stream, "'to' space", this.bytesInToBefore, this.bytesInToAfter);
        this.printSpace(stream, "young generation", this.bytesInEdenBefore + this.bytesInFromBefore + this.bytesInToBefore, this.bytesInEdenAfter + this.bytesInFromAfter + this.bytesInToAfter);
        this.printSpace(stream, "old generation", this.bytesInOldBefore, this.bytesInOldAfter);
        if (this.ver() < 1) {
            this.printSpace(stream, "perm generation", this.bytesInPermBefore, this.bytesInPermAfter);
        }
        stream.formatln("System load average                     : %.2f, %.2f, %.2f", this.systemLoadAverage[0], this.systemLoadAverage[1], this.systemLoadAverage[2]);
        stream.formatln("Host CPU utilization (virtualized)      : %.2f, %.2f, %.2f", this.virtualCpuUtilization[0], this.virtualCpuUtilization[1], this.virtualCpuUtilization[2]);
    }

    @Override
    public long getBytesInEdenAfter() {
        return this.bytesInEdenAfter;
    }

    @Override
    public long getBytesInEdenBefore() {
        return this.bytesInEdenBefore;
    }

    @Override
    public long getBytesInFromAfter() {
        return this.bytesInFromAfter;
    }

    @Override
    public long getBytesInFromBefore() {
        return this.bytesInFromBefore;
    }

    @Override
    public long getBytesInOldAfter() {
        return this.bytesInOldAfter;
    }

    @Override
    public long getBytesInOldBefore() {
        return this.bytesInOldBefore;
    }

    @Override
    public long getBytesInPermAfter() {
        return this.bytesInPermAfter;
    }

    @Override
    public long getBytesInPermBefore() {
        return this.bytesInPermBefore;
    }

    @Override
    public long getBytesInToAfter() {
        return this.bytesInToAfter;
    }

    @Override
    public long getBytesInToBefore() {
        return this.bytesInToBefore;
    }

    @Override
    public double[] getSystemLoadAverage() {
        return (double[])this.systemLoadAverage.clone();
    }

    @Override
    public double[] getVirtualCpuUtilization() {
        return (double[])this.virtualCpuUtilization.clone();
    }
}

