/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GcEventGenerationalImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventParallelGcScavenge;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public final class GcEventParallelGcScavengeImpl
extends GcEventGenerationalImpl
implements GcEventParallelGcScavenge {
    private final boolean promotionFailed;
    private final long successfulSteals;
    private final long failedSteals;
    private final long failedStealsWithYield;
    private final int[] ageCounts;
    private final int[] ageSizes;
    private final long plabSize;

    public GcEventParallelGcScavengeImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.readDurationsAndPageFaults(reader, mapInfo, statistic);
        this.readGenerationsAndLoad(reader, mapInfo, statistic);
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        boolean exact = statistic.isExact();
        this.promotionFailed = reader.readBoolean();
        this.successfulSteals = reader.readCompressedInt32();
        this.failedSteals = reader.readCompressedInt32();
        this.failedStealsWithYield = reader.readCompressedInt32();
        this.plabSize = reader.readScaledInt32(1024L, exact);
        this.ageCounts = new int[32];
        this.ageSizes = new int[32];
        long youngObjectCount = reader.readInt64Percentage(statistic.getMaxYoungGenSize() / (long)history.getMinObjectSize(), exact);
        for (int i = 0; i <= history.getMaxObjectAge(); ++i) {
            this.ageCounts[i] = (int)reader.readInt64Percentage(youngObjectCount, exact);
        }
        long youngObjectSize = reader.readInt64Percentage(statistic.getMaxYoungGenSize(), exact);
        for (int i = 0; i <= history.getMaxObjectAge(); ++i) {
            this.ageSizes[i] = (int)reader.readInt64Percentage(youngObjectSize, exact);
        }
        this.readVirtualizedLoad(reader, mapInfo, statistic);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.println("Promotion failed                        : " + (this.promotionFailed ? "yes" : "no"));
        stream.println("Number of successful steal operations   : " + this.successfulSteals);
        stream.println("Number of failed steal operations       : " + this.failedSteals);
        stream.println("Number of failed steals and yields      : " + this.failedStealsWithYield);
        stream.formatln("Size of 'to' space PLAB (per thread)    : %*B", this.plabSize);
        for (int i = 0; i < 32; ++i) {
            stream.formatln("Objects of age %2d                       : %d, %*B", i, this.ageCounts[i], this.ageSizes[i]);
        }
    }

    @Override
    public boolean isPromotionFailed() {
        return this.promotionFailed;
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.PARALLEL_GC_SCAVENGE;
    }

    @Override
    public int[] getAgeCounts() {
        int[] copy = new int[this.ageCounts.length];
        System.arraycopy(this.ageCounts, 0, copy, 0, this.ageCounts.length);
        return copy;
    }

    @Override
    public int[] getAgeSizes() {
        int[] copy = new int[this.ageSizes.length];
        System.arraycopy(this.ageSizes, 0, copy, 0, this.ageSizes.length);
        return copy;
    }

    @Override
    public long getFailedSteals() {
        return this.failedSteals;
    }

    @Override
    public long getFailedStealsWithYield() {
        return this.failedStealsWithYield;
    }

    @Override
    public long getPLABSize() {
        return this.plabSize;
    }

    @Override
    public long getSuccessfulSteals() {
        return this.successfulSteals;
    }
}

