/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GcEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventParallelSmallGcForcedFullGc;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public final class GcEventParallelSmallGcForcedFullGcImpl
extends GcEventBaseImpl
implements GcEventParallelSmallGcForcedFullGc {
    private final long averagePromoted;

    protected GcEventParallelSmallGcForcedFullGcImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.averagePromoted = reader.readInt64Percentage(statistic.getMaxYoungGenSize(), statistic.isExact());
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.PARALLEL_GC_SMALL_FORCED_FULL_GC;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.formatln("Expected promoted bytes for next GC     : %*B", this.averagePromoted);
    }

    @Override
    public long getAveragePromoted() {
        return this.averagePromoted;
    }
}

