/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.event.SystemInfo;
import com.sap.jvm.profiling.impl.memory.event.GcDurationEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventReferenceHandling;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.EOFException;
import java.io.IOException;

public abstract class GcEventReferenceHandlingImpl
extends GcDurationEventBaseImpl
implements GcEventReferenceHandling {
    private final int softReferencesFound;
    private final int softReferencesCleared;
    private final int softReferencesNotCleared;
    private final int softReferencesEnqueued;
    private final long softReferenceMaxLastUsedTime;
    private final int weakReferencesFound;
    private final int weakReferencesCleared;
    private final int weakReferencesEnqueued;
    private final int phantomReferencesFound;
    private final int phantomReferencesEnqueued;
    private final int finalReferencesFound;
    private final int finalReferencesEnqueued;
    private final int softReferencesFoundInSoftReferenceHandling;
    private final int weakReferencesFoundInSoftReferenceHandling;
    private final int finalReferencesFoundInSoftReferenceHandling;
    private final int phantomReferencesFoundInSoftReferenceHandling;
    private final int softReferencesFoundInPhantomReferenceHandling;
    private final int weakReferencesFoundInPhantomReferenceHandling;
    private final int finalReferencesFoundInPhantomReferenceHandling;
    private final int phantomReferencesFoundInPhantomReferenceHandling;
    private final int softReferencesFoundInFinalReferenceHandling;
    private final int weakReferencesFoundInFinalReferenceHandling;
    private final int finalReferencesFoundInFinalReferenceHandling;
    private final int phantomReferencesFoundInFinalReferenceHandling;
    private final int softReferencesFoundInPreprocessing;
    private final int deadSoftReferencesFoundInPreprocessing;
    private final int softReferencesResurrectedInPreprocessing;
    private final long softReferenceHandlingDuration;
    private final long softReferenceHandlingCpuTime;
    private final long weakReferenceHandlingDuration;
    private final long weakReferenceHandlingCpuTime;
    private final long finalReferenceHandlingDuration;
    private final long finalReferenceHandlingCpuTime;
    private final long phantomReferenceHandlingDuration;
    private final long phantomReferenceHandlingCpuTime;
    private final long jniWeakReferenceHandlingDuration;
    private final long jniWeakReferenceHandlingCpuTime;
    private final int softReferencesResurrectedByPolicy;
    private final long jniWeakRefAlive;
    private final long jniWeakRefDead;
    private final long transitionToSingleThreadingDuration;
    private final long transitionToSingleThreadingCpuTime;

    public GcEventReferenceHandlingImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        long tmpTransitionToSingleThreadingCpuTime;
        long tmpTransitionToSingleThreadingDuration;
        block9: {
            long tmpJniWeakRefDead;
            long tmpJniWeakRefAlive;
            int index;
            boolean[] zeroBitmap;
            boolean exact;
            block8: {
                super(reader, mapInfo, statistic);
                this.readTimestamp(reader, mapInfo, statistic);
                this.readDurationsAndPageFaults(reader, mapInfo, statistic);
                exact = statistic.isExact();
                zeroBitmap = new boolean[40];
                int dstStart = 0;
                for (int i = 0; i < 5; ++i) {
                    boolean[] tmpBitmap = reader.readBooleanArray();
                    System.arraycopy(tmpBitmap, 0, zeroBitmap, dstStart, tmpBitmap.length);
                    dstStart += tmpBitmap.length;
                }
                index = 0;
                this.softReferencesFound = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.softReferencesCleared = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.softReferencesNotCleared = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.softReferencesEnqueued = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.weakReferencesFound = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.weakReferencesCleared = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.weakReferencesEnqueued = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.phantomReferencesFound = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.phantomReferencesEnqueued = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.finalReferencesFound = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.finalReferencesEnqueued = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.softReferenceMaxLastUsedTime = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.softReferencesFoundInSoftReferenceHandling = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.weakReferencesFoundInSoftReferenceHandling = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.finalReferencesFoundInSoftReferenceHandling = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.phantomReferencesFoundInSoftReferenceHandling = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.softReferencesFoundInPhantomReferenceHandling = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.weakReferencesFoundInPhantomReferenceHandling = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.finalReferencesFoundInPhantomReferenceHandling = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.phantomReferencesFoundInPhantomReferenceHandling = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.softReferencesFoundInFinalReferenceHandling = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.weakReferencesFoundInFinalReferenceHandling = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.finalReferencesFoundInFinalReferenceHandling = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.phantomReferencesFoundInFinalReferenceHandling = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.softReferencesFoundInPreprocessing = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.deadSoftReferencesFoundInPreprocessing = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.softReferencesResurrectedInPreprocessing = this.readCompressedInt32(reader, zeroBitmap[index++]);
                this.softReferenceHandlingDuration = this.readScaledInt32(reader, zeroBitmap[index++], 1000L, exact);
                this.softReferenceHandlingCpuTime = this.readScaledInt32(reader, zeroBitmap[index++], 1000L, exact);
                this.weakReferenceHandlingDuration = this.readScaledInt32(reader, zeroBitmap[index++], 1000L, exact);
                this.weakReferenceHandlingCpuTime = this.readScaledInt32(reader, zeroBitmap[index++], 1000L, exact);
                this.finalReferenceHandlingDuration = this.readScaledInt32(reader, zeroBitmap[index++], 1000L, exact);
                this.finalReferenceHandlingCpuTime = this.readScaledInt32(reader, zeroBitmap[index++], 1000L, exact);
                this.phantomReferenceHandlingDuration = this.readScaledInt32(reader, zeroBitmap[index++], 1000L, exact);
                this.phantomReferenceHandlingCpuTime = this.readScaledInt32(reader, zeroBitmap[index++], 1000L, exact);
                this.jniWeakReferenceHandlingDuration = this.readScaledInt32(reader, zeroBitmap[index++], 1000L, exact);
                this.jniWeakReferenceHandlingCpuTime = this.readScaledInt32(reader, zeroBitmap[index++], 1000L, exact);
                this.softReferencesResurrectedByPolicy = this.readCompressedInt32(reader, zeroBitmap[index++]);
                tmpJniWeakRefAlive = 0L;
                tmpJniWeakRefDead = 0L;
                if (reader.hasNext()) {
                    SystemInfo systemInfo = mapInfo.getSession().getSystemInfo();
                    boolean isZero = false;
                    if (systemInfo != null && systemInfo.supportsReallyAdvancedReferenceHandling()) {
                        isZero = zeroBitmap[index++];
                    }
                    try {
                        tmpJniWeakRefAlive = this.readExpCompressedUint32(reader, isZero, exact);
                        tmpJniWeakRefDead = this.readExpCompressedUint32(reader, zeroBitmap[index++], exact);
                    }
                    catch (EOFException e) {
                        if ($assertionsDisabled || systemInfo == null || !systemInfo.supportsReallyAdvancedReferenceHandling()) break block8;
                        throw new AssertionError();
                    }
                }
            }
            this.jniWeakRefAlive = tmpJniWeakRefAlive;
            this.jniWeakRefDead = tmpJniWeakRefDead;
            tmpTransitionToSingleThreadingDuration = 0L;
            tmpTransitionToSingleThreadingCpuTime = 0L;
            if (reader.hasNext() && this.ver() < 3) {
                zeroBitmap = reader.readBooleanArray();
                index = 0;
                try {
                    tmpTransitionToSingleThreadingDuration = this.readScaledInt32(reader, zeroBitmap[index++], 1000L, exact);
                    tmpTransitionToSingleThreadingCpuTime = this.readScaledInt32(reader, zeroBitmap[index++], 1000L, exact);
                }
                catch (EOFException e) {
                    SystemInfo systemInfo = mapInfo.getSession().getSystemInfo();
                    if ($assertionsDisabled || systemInfo == null || !systemInfo.supportsReallyAdvancedReferenceHandling()) break block9;
                    throw new AssertionError();
                }
            }
        }
        this.transitionToSingleThreadingDuration = tmpTransitionToSingleThreadingDuration;
        this.transitionToSingleThreadingCpuTime = tmpTransitionToSingleThreadingCpuTime;
    }

    private int readCompressedInt32(ByteArrayBasicResourceReader reader, boolean isZero) throws IOException {
        return isZero ? 0 : reader.readCompressedInt32();
    }

    private long readExpCompressedUint32(ByteArrayBasicResourceReader reader, boolean isZero, boolean exact) throws IOException {
        return isZero ? 0L : reader.readExpCompressedUint32(exact);
    }

    private long readScaledInt32(ByteArrayBasicResourceReader reader, boolean isZero, long scale, boolean exact) throws IOException {
        return isZero ? 0L : reader.readScaledInt32(scale, exact);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.println("Max last used time (ms) of SoftRefs     : " + this.softReferenceMaxLastUsedTime + " ms");
        stream.println("Nr. of SoftRefs found                   : " + this.softReferencesFound);
        stream.println("Nr. of SoftRefs kept alive by policy    : " + this.softReferencesResurrectedByPolicy);
        stream.println("Nr. of dead SoftRefs cleared            : " + this.softReferencesCleared);
        stream.println("Nr. of dead SoftRefs not cleared        : " + this.softReferencesNotCleared);
        stream.println("Nr. of live SoftRefs                    : " + (this.softReferencesFound - this.softReferencesCleared - this.softReferencesNotCleared));
        stream.println("Nr. of SoftRefs newly enqueued          : " + this.softReferencesEnqueued);
        stream.println("Nr. of new alive SoftRefs found         : " + this.softReferencesFoundInSoftReferenceHandling);
        stream.println("        during SoftRef handling");
        stream.println("Nr. of new alive WeakRefs found         : " + this.weakReferencesFoundInSoftReferenceHandling);
        stream.println("        during SoftRef handling");
        stream.println("Nr. of new alive FinalRefs found        : " + this.finalReferencesFoundInSoftReferenceHandling);
        stream.println("        during SoftRef handling");
        stream.println("Nr. of new alive PhantomRefs found      : " + this.phantomReferencesFoundInSoftReferenceHandling);
        stream.println("        during SoftRef handling");
        stream.println("Nr. of WeakRefs found                   : " + this.weakReferencesFound);
        stream.println("Nr. of dead WeakRefs                    : " + this.weakReferencesCleared);
        stream.println("Nr. of live WeakRefs                    : " + (this.weakReferencesFound - this.weakReferencesCleared));
        stream.println("Nr. of WeakRefs newly enqueued          : " + this.weakReferencesEnqueued);
        stream.println("Nr. of FinalRefs found                  : " + this.finalReferencesFound);
        stream.println("Nr. of live FinalRefs                   : " + (this.finalReferencesFound - this.finalReferencesEnqueued));
        stream.println("Nr. of FinalRefs newly enqueued         : " + this.finalReferencesEnqueued);
        stream.println("Nr. of new alive SoftRefs found         : " + this.softReferencesFoundInFinalReferenceHandling);
        stream.println("        during FinalRef handling");
        stream.println("Nr. of new alive WeakRefs found         : " + this.weakReferencesFoundInFinalReferenceHandling);
        stream.println("        during FinalRef handling");
        stream.println("Nr. of new alive FinalRefs found        : " + this.finalReferencesFoundInFinalReferenceHandling);
        stream.println("        during FinalRef handling");
        stream.println("Nr. of new alive PhantomRefs found      : " + this.phantomReferencesFoundInFinalReferenceHandling);
        stream.println("        during FinalRef handling");
        stream.println("Nr. of PhantomRefs found                : " + this.phantomReferencesFound);
        stream.println("Nr. of live PhantomRefs                 : " + (this.phantomReferencesFound - this.phantomReferencesEnqueued));
        stream.println("Nr. of PhantomRefs newly enqueued       : " + this.phantomReferencesEnqueued);
        stream.println("Nr. of new alive SoftRefs found         : " + this.softReferencesFoundInPhantomReferenceHandling);
        stream.println("        during PhantomRef handling");
        stream.println("Nr. of new alive WeakRefs found         : " + this.weakReferencesFoundInPhantomReferenceHandling);
        stream.println("        during PhantomRef handling");
        stream.println("Nr. of new alive FinalRefs found        : " + this.finalReferencesFoundInPhantomReferenceHandling);
        stream.println("        during PhantomRef handling");
        stream.println("Nr. of new alive PhantomRefs found      : " + this.phantomReferencesFoundInPhantomReferenceHandling);
        stream.println("        during PhantomRef handling");
        stream.println("Nr. of SoftRefs found (preproc.)        : " + this.softReferencesFoundInPreprocessing);
        stream.println("Nr. of dead SoftRefs found (preproc.)   : " + this.deadSoftReferencesFoundInPreprocessing);
        stream.println("Nr. of dead SoftRefs resurrected (pp.)  : " + this.softReferencesResurrectedInPreprocessing);
        stream.println("Nr. of JNI weak references found        : " + this.jniWeakRefAlive + this.jniWeakRefDead);
        stream.println("Nr. of JNI alive weak references        : " + this.jniWeakRefAlive);
        stream.println("Nr. of JNI dead weak references         : " + this.jniWeakRefDead);
        stream.formatln("Soft reference handling duration        : %.2f ms", (double)this.softReferenceHandlingDuration / 1000.0);
        stream.formatln("Soft reference handling CPU time        : %.2f ms", (double)this.softReferenceHandlingCpuTime / 1000.0);
        stream.formatln("Weak reference handling duration        : %.2f ms", (double)this.weakReferenceHandlingDuration / 1000.0);
        stream.formatln("Weak reference handling CPU time        : %.2f ms", (double)this.weakReferenceHandlingCpuTime / 1000.0);
        stream.formatln("Final reference handling duration       : %.2f ms", (double)this.finalReferenceHandlingDuration / 1000.0);
        stream.formatln("Final reference handling CPU time       : %.2f ms", (double)this.finalReferenceHandlingCpuTime / 1000.0);
        stream.formatln("Phantom reference handling duration     : %.2f ms", (double)this.phantomReferenceHandlingDuration / 1000.0);
        stream.formatln("Phantom reference handling CPU time     : %.2f ms", (double)this.phantomReferenceHandlingCpuTime / 1000.0);
        stream.formatln("JNI weak reference handling duration    : %.2f ms", (double)this.jniWeakReferenceHandlingDuration / 1000.0);
        stream.formatln("JNI weak reference handling CPU time    : %.2f ms", (double)this.jniWeakReferenceHandlingCpuTime / 1000.0);
        if (this.ver() < 3) {
            stream.formatln("Transition to serial part duration      : %.2f ms", (double)this.transitionToSingleThreadingDuration / 1000.0);
            stream.formatln("Transition to serial part CPU time      : %.2f ms", (double)this.transitionToSingleThreadingCpuTime / 1000.0);
        }
    }

    @Override
    public int getFinalReferencesEnqueued() {
        return this.finalReferencesEnqueued;
    }

    @Override
    public int getFinalReferencesFound() {
        return this.finalReferencesFound;
    }

    @Override
    public int getPhantomReferencesEnqueued() {
        return this.phantomReferencesEnqueued;
    }

    @Override
    public int getPhantomReferencesFound() {
        return this.phantomReferencesFound;
    }

    @Override
    public int getSoftReferencesCleared() {
        return this.softReferencesCleared;
    }

    @Override
    public int getSoftReferencesEnqueued() {
        return this.softReferencesEnqueued;
    }

    @Override
    public long getSoftReferenceMaxLastUsedTime() {
        return this.softReferenceMaxLastUsedTime;
    }

    @Override
    public int getSoftReferencesFound() {
        return this.softReferencesFound;
    }

    @Override
    public int getSoftReferencesNotCleared() {
        return this.softReferencesNotCleared;
    }

    @Override
    public int getWeakReferencesCleared() {
        return this.weakReferencesCleared;
    }

    @Override
    public int getWeakReferencesEnqueued() {
        return this.weakReferencesEnqueued;
    }

    @Override
    public int getWeakReferencesFound() {
        return this.weakReferencesFound;
    }

    @Override
    public int getDeadSoftReferencesFoundInPreprocessing() {
        return this.deadSoftReferencesFoundInPreprocessing;
    }

    @Override
    public long getFinalReferenceHandlingCpuTime() {
        return this.finalReferenceHandlingCpuTime;
    }

    @Override
    public long getFinalReferenceHandlingDuration() {
        return this.finalReferenceHandlingDuration;
    }

    @Override
    public int getFinalReferencesFoundInFinalReferenceHandling() {
        return this.finalReferencesFoundInFinalReferenceHandling;
    }

    @Override
    public int getFinalReferencesFoundInPhantomReferenceHandling() {
        return this.finalReferencesFoundInPhantomReferenceHandling;
    }

    @Override
    public int getFinalReferencesFoundInSoftReferenceHandling() {
        return this.finalReferencesFoundInSoftReferenceHandling;
    }

    @Override
    public long getJNIWeakReferenceHandlingCpuTime() {
        return this.jniWeakReferenceHandlingCpuTime;
    }

    @Override
    public long getJNIWeakReferenceHandlingDuration() {
        return this.jniWeakReferenceHandlingDuration;
    }

    @Override
    public long getPhantomReferenceHandlingCpuTime() {
        return this.phantomReferenceHandlingCpuTime;
    }

    @Override
    public long getPhantomReferenceHandlingDuration() {
        return this.phantomReferenceHandlingDuration;
    }

    @Override
    public int getPhantomReferencesFoundInFinalReferenceHandling() {
        return this.phantomReferencesFoundInFinalReferenceHandling;
    }

    @Override
    public int getPhantomReferencesFoundInPhantomReferenceHandling() {
        return this.phantomReferencesFoundInPhantomReferenceHandling;
    }

    @Override
    public int getPhantomReferencesFoundInSoftReferenceHandling() {
        return this.phantomReferencesFoundInSoftReferenceHandling;
    }

    @Override
    public long getSoftReferenceHandlingCpuTime() {
        return this.softReferenceHandlingCpuTime;
    }

    @Override
    public long getSoftReferenceHandlingDuration() {
        return this.softReferenceHandlingDuration;
    }

    @Override
    public int getSoftReferencesFoundInFinalReferenceHandling() {
        return this.softReferencesFoundInFinalReferenceHandling;
    }

    @Override
    public int getSoftReferencesFoundInPhantomReferenceHandling() {
        return this.softReferencesFoundInPhantomReferenceHandling;
    }

    @Override
    public int getSoftReferencesFoundInPreprocessing() {
        return this.softReferencesFoundInPreprocessing;
    }

    @Override
    public int getSoftReferencesFoundInSoftReferenceHandling() {
        return this.softReferencesFoundInSoftReferenceHandling;
    }

    @Override
    public int getSoftReferencesResurrectedByPolicy() {
        return this.softReferencesResurrectedByPolicy;
    }

    @Override
    public int getSoftReferencesResurrectedInPreprocessing() {
        return this.softReferencesResurrectedInPreprocessing;
    }

    @Override
    public long getWeakReferenceHandlingCpuTime() {
        return this.weakReferenceHandlingCpuTime;
    }

    @Override
    public long getWeakReferenceHandlingDuration() {
        return this.weakReferenceHandlingDuration;
    }

    @Override
    public int getWeakReferencesFoundInFinalReferenceHandling() {
        return this.weakReferencesFoundInFinalReferenceHandling;
    }

    @Override
    public int getWeakReferencesFoundInPhantomReferenceHandling() {
        return this.weakReferencesFoundInPhantomReferenceHandling;
    }

    @Override
    public int getWeakReferencesFoundInSoftReferenceHandling() {
        return this.weakReferencesFoundInSoftReferenceHandling;
    }

    @Override
    public long getJNIWeakRefsAlive() {
        return this.jniWeakRefAlive;
    }

    @Override
    public long getJNIWeakRefsDeads() {
        return this.jniWeakRefDead;
    }

    @Override
    public long getTransitionToSingleThreadingDuration() {
        return this.transitionToSingleThreadingDuration;
    }

    @Override
    public long getTransitionToSingleThreadingCpuTime() {
        return this.transitionToSingleThreadingCpuTime;
    }
}

