/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GCHistoryInitialValues;
import com.sap.jvm.profiling.impl.memory.event.GcEventGenerationalImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventSerialNewGc;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public final class GcEventSerialNewGcImpl
extends GcEventGenerationalImpl
implements GcEventSerialNewGc {
    private final boolean clearSoftRefs;
    private final boolean promotionFailed;
    private final int[] ageCounts;
    private final int[] ageSizes;
    private final long largestContiguousBlockInOld;

    public GcEventSerialNewGcImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.readDurationsAndPageFaults(reader, mapInfo, statistic);
        this.readGenerationsAndLoad(reader, mapInfo, statistic);
        GCHistoryInitialValues history = mapInfo.getGcHistoryInitialValues();
        boolean exact = statistic.isExact();
        boolean[] bools = reader.readBooleanArray();
        this.clearSoftRefs = bools[0];
        this.promotionFailed = bools[1];
        this.largestContiguousBlockInOld = reader.readInt64Percentage(statistic.getMaxOldGenSize(), exact);
        this.ageCounts = new int[32];
        this.ageSizes = new int[32];
        long youngObjectCount = reader.readInt64Percentage(statistic.getMaxYoungGenSize() / (long)history.getMinObjectSize(), exact);
        for (int i = 0; i <= history.getMaxObjectAge(); ++i) {
            this.ageCounts[i] = (int)reader.readInt64Percentage(youngObjectCount, exact);
        }
        long youngObjectSize = reader.readInt64Percentage(statistic.getMaxYoungGenSize(), exact);
        for (int i = 0; i <= history.getMaxObjectAge(); ++i) {
            this.ageSizes[i] = (int)reader.readInt64Percentage(youngObjectSize, exact);
        }
        this.readVirtualizedLoad(reader, mapInfo, statistic);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.println("Promotion failed                        : " + (this.promotionFailed ? "yes" : "no"));
        stream.println("Forced clearing of soft references      : " + (this.clearSoftRefs ? "yes" : "no"));
        stream.formatln("Largest contiguous block in old gen     : %*B", this.largestContiguousBlockInOld);
        for (int i = 0; i < 32; ++i) {
            stream.formatln("Objects of age %2d                       : %d, %*B", i, this.ageCounts[i], this.ageSizes[i]);
        }
    }

    @Override
    public boolean isPromotionFailed() {
        return this.promotionFailed;
    }

    @Override
    public boolean isClearSoftRefs() {
        return this.clearSoftRefs;
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.SERIAL_NEW_GC;
    }

    @Override
    public int[] getAgeCounts() {
        int[] copy = new int[this.ageCounts.length];
        System.arraycopy(this.ageCounts, 0, copy, 0, this.ageCounts.length);
        return copy;
    }

    @Override
    public int[] getAgeSizes() {
        int[] copy = new int[this.ageSizes.length];
        System.arraycopy(this.ageSizes, 0, copy, 0, this.ageSizes.length);
        return copy;
    }

    @Override
    public long getLargestContiguousBlockInOld() {
        return this.largestContiguousBlockInOld;
    }
}

