/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GcEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventSkippedGc;
import com.sap.jvm.profiling.memory.event.GcSkippedReason;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;

public abstract class GcEventSkippedGcImpl
extends GcEventBaseImpl
implements GcEventSkippedGc {
    private final GcSkippedReason reason;

    public GcEventSkippedGcImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        this.reason = this.getGcSkippedReason(reader.readInt8());
    }

    private GcSkippedReason getGcSkippedReason(int value) {
        switch (value) {
            case 0: {
                return GcSkippedReason.TIME_LIMIT;
            }
            case 1: {
                return GcSkippedReason.TO_SPACE_NOT_EMPTY;
            }
            case 2: {
                return GcSkippedReason.SCAVENGE_WITH_OBJECTS_IN_TO_SPACE_DISABLED;
            }
            case 3: {
                return GcSkippedReason.PROMOTION_PROBABLY_FAILS;
            }
            case 4: {
                return GcSkippedReason.PROMOTION_CAN_FAIL;
            }
            case 5: {
                return GcSkippedReason.GC_LOCKER_ACTIVE;
            }
            case 6: {
                return GcSkippedReason.UNNECESSARY_GC;
            }
        }
        throw new IllegalArgumentException("Unknown reason for skipping this GC " + value);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.println("GC Reason                                : " + this.reason.getDescription());
    }

    @Override
    public GcSkippedReason getReason() {
        return this.reason;
    }
}

