/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.memory.event;

import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.memory.event.GcEventBaseImpl;
import com.sap.jvm.profiling.impl.memory.event.GcStatisticImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.memory.event.GcEventYoungGenPromotionFailure;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import java.io.IOException;
import java.util.Date;

public final class GcEventYoungGenPromotionFailureImpl
extends GcEventBaseImpl
implements GcEventYoungGenPromotionFailure {
    private final String causingObjectType;
    private final long causingObjectSize;
    private final long largestContiguousBlockInOld;
    private final int failedPromotionsCount;
    private final long promotionFailureNr;
    private final long firstPromotionFailureTimestamp;

    protected GcEventYoungGenPromotionFailureImpl(ByteArrayBasicResourceReader reader, MappingInformation mapInfo, GcStatisticImpl statistic) throws IOException {
        super(reader, mapInfo, statistic);
        this.readTimestamp(reader, mapInfo, statistic);
        boolean exact = statistic.isExact();
        this.causingObjectType = reader.readString();
        this.causingObjectSize = reader.readCompressedInt32();
        this.largestContiguousBlockInOld = reader.readInt64Percentage(statistic.getMaxOldGenSize(), exact);
        this.failedPromotionsCount = reader.readCompressedInt32();
        this.promotionFailureNr = reader.readCompressedInt32();
        this.firstPromotionFailureTimestamp = reader.readCompressedInt64() + statistic.getTimestamp();
    }

    @Override
    public GcEventType getGcEventType() {
        return GcEventType.YOUNG_GEN_PROMOTION_FAILURE;
    }

    @Override
    public long getCausingObjectSize() {
        return this.causingObjectSize;
    }

    @Override
    public String getCausingObjectType() {
        return this.causingObjectType;
    }

    @Override
    public int getFailedPromotionsCount() {
        return this.failedPromotionsCount;
    }

    @Override
    public long getLargestContiguousBlockInOld() {
        return this.largestContiguousBlockInOld;
    }

    @Override
    public long getPromotionFailureNr() {
        return this.promotionFailureNr;
    }

    @Override
    public long getFirstPromotionFailureTimestamp() {
        return this.firstPromotionFailureTimestamp;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        super.print(stream);
        stream.println("Promotion failure Nr.                   : " + this.promotionFailureNr);
        stream.println("Largest object type causing prom failure: " + this.causingObjectType);
        stream.formatln("Largest object size causing prom failure: %*B", this.causingObjectSize);
        stream.formatln("Largest contiguous block in old gen     : %*B", this.largestContiguousBlockInOld);
        stream.println("Nr. of failed object promotions         : " + this.failedPromotionsCount);
        stream.println("Time of first promotion failure         : " + new Date(this.firstPromotionFailureTimestamp));
    }
}

